/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;

public abstract class AbstractXPathMessageSelector
implements MessageSelector {
    private final XPathExpression xPathExpression;
    private volatile XmlPayloadConverter converter = new DefaultXmlPayloadConverter();

    public AbstractXPathMessageSelector(String xPathExpression) {
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)xPathExpression);
    }

    public AbstractXPathMessageSelector(String xPathExpression, String prefix, String namespace) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(prefix, namespace);
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)xPathExpression, namespaces);
    }

    public AbstractXPathMessageSelector(String xPathExpression, Map<String, String> namespaces) {
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)xPathExpression, namespaces);
    }

    public AbstractXPathMessageSelector(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public void setConverter(XmlPayloadConverter converter) {
        this.converter = converter;
    }

    protected XmlPayloadConverter getConverter() {
        return this.converter;
    }

    protected XPathExpression getXPathExpression() {
        return this.xPathExpression;
    }
}

