/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer.support;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.util.BeanFactoryTypeConverter;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Node;

public class XPathExpressionEvaluatingHeaderValueMessageProcessor
implements HeaderValueMessageProcessor<Object>,
BeanFactoryAware {
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private final XPathExpression expression;
    private final XmlPayloadConverter converter;
    private XPathEvaluationType evaluationType = XPathEvaluationType.STRING_RESULT;
    private @Nullable TypeDescriptor headerTypeDescriptor;
    private @Nullable Boolean overwrite;

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(String expression) {
        this(expression, (XmlPayloadConverter)new DefaultXmlPayloadConverter());
    }

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(String expression, XmlPayloadConverter converter) {
        this(XPathExpressionFactory.createXPathExpression((String)expression), converter);
    }

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(XPathExpression expression) {
        this(expression, (XmlPayloadConverter)new DefaultXmlPayloadConverter());
    }

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(XPathExpression expression, XmlPayloadConverter converter) {
        Assert.notNull((Object)expression, (String)"'expression' must not be null.");
        Assert.notNull((Object)converter, (String)"'converter' must not be null.");
        this.expression = expression;
        this.converter = converter;
    }

    public void setEvaluationType(XPathEvaluationType evaluationType) {
        this.evaluationType = evaluationType;
    }

    public void setHeaderType(Class<?> headerType) {
        if (headerType != null) {
            this.headerTypeDescriptor = TypeDescriptor.valueOf(headerType);
        }
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public @Nullable Boolean isOverwrite() {
        return this.overwrite;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)beanFactory);
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    public @Nullable Object processMessage(Message<?> message) {
        String string;
        Node node = this.converter.convertToNode(message.getPayload());
        Object result = this.evaluationType.evaluateXPath(this.expression, node);
        if (result instanceof String && (string = (String)result).isEmpty()) {
            result = null;
        }
        if (result != null && this.headerTypeDescriptor != null) {
            return this.typeConverter.convertValue(result, TypeDescriptor.forObject((Object)result), this.headerTypeDescriptor);
        }
        return result;
    }
}

