/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.config.XPathExpressionParser;
import org.springframework.integration.xml.splitter.XPathMessageSplitter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XPathMessageSplitterParser
extends AbstractConsumerEndpointParser {
    private final XPathExpressionParser xpathParser = new XPathExpressionParser();

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XPathMessageSplitter.class);
        String xPathExpressionRef = element.getAttribute("xpath-expression-ref");
        NodeList xPathExpressionNodes = element.getElementsByTagNameNS(element.getNamespaceURI(), "xpath-expression");
        Assert.isTrue((xPathExpressionNodes.getLength() <= 1 ? 1 : 0) != 0, (String)"At most one xpath-expression child may be specified.");
        boolean hasChild = xPathExpressionNodes.getLength() == 1;
        boolean hasReference = StringUtils.hasText((String)xPathExpressionRef);
        Assert.isTrue((boolean)(hasChild ^ hasReference), (String)"Exactly one of 'xpath-expression' or 'xpath-expression-ref' is required.");
        if (hasChild) {
            BeanDefinition beanDefinition = this.xpathParser.parse((Element)xPathExpressionNodes.item(0), parserContext);
            builder.addConstructorArgValue((Object)beanDefinition);
        } else {
            builder.addConstructorArgReference(xPathExpressionRef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"doc-builder-factory", (String)"documentBuilder");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"create-documents");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"apply-sequence");
        return builder;
    }
}

