/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.inbound;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.ws.inbound.AbstractWebServiceInboundGateway;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceInboundGateway
extends AbstractWebServiceInboundGateway {
    private final TransformerSupportDelegate transformerSupportDelegate = new TransformerSupportDelegate();
    private boolean extractPayload = true;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    @Override
    protected void doInvoke(MessageContext messageContext) {
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload((Object)(this.extractPayload ? request.getPayloadSource() : request));
        this.fromSoapHeaders(messageContext, builder);
        Message replyMessage = this.sendAndReceiveMessage(builder.build());
        if (replyMessage != null) {
            Object replyPayload = replyMessage.getPayload();
            if (replyPayload instanceof WebServiceMessage) {
                WebServiceMessage webServiceMessage = (WebServiceMessage)replyPayload;
                messageContext.setResponse(webServiceMessage);
            } else {
                Source responseSource;
                if (replyPayload instanceof Source) {
                    Source source;
                    responseSource = source = (Source)replyPayload;
                } else if (replyPayload instanceof Document) {
                    Document document = (Document)replyPayload;
                    responseSource = new DOMSource(document);
                } else if (replyPayload instanceof String) {
                    String string = (String)replyPayload;
                    responseSource = new StringSource(string);
                } else {
                    throw new IllegalArgumentException("The reply Message payload must be a [" + Source.class.getName() + "], [" + Document.class.getName() + "], [java.lang.String] or [" + WebServiceMessage.class.getName() + "]. The actual type was [" + replyPayload.getClass().getName() + "]");
                }
                WebServiceMessage response = messageContext.getResponse();
                try {
                    this.transformerSupportDelegate.transformSourceToResult(responseSource, response.getPayloadResult());
                }
                catch (TransformerException e) {
                    throw new IllegalStateException(e);
                }
                this.toSoapHeaders(response, replyMessage);
            }
        }
    }

    private static class TransformerSupportDelegate
    extends TransformerObjectSupport {
        TransformerSupportDelegate() {
        }

        void transformSourceToResult(Source source, Result result) throws TransformerException {
            this.transform(source, result);
        }
    }
}

