/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.dsl;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.ws.MarshallingWebServiceOutboundGateway;
import org.springframework.integration.ws.dsl.BaseWsOutboundGatewaySpec;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class MarshallingWsOutboundGatewaySpec
extends BaseWsOutboundGatewaySpec<MarshallingWsOutboundGatewaySpec, MarshallingWebServiceOutboundGateway> {
    protected MarshallingWsOutboundGatewaySpec(WebServiceTemplate template) {
        this.template = template;
    }

    @Override
    protected MarshallingWebServiceOutboundGateway create() {
        if (this.destinationProvider != null) {
            return new MarshallingWebServiceOutboundGateway(this.destinationProvider, this.template);
        }
        return new MarshallingWebServiceOutboundGateway(this.uri, this.template);
    }

    public static class MarshallingWsOutboundGatewayNoTemplateSpec
    extends BaseWsOutboundGatewaySpec<MarshallingWsOutboundGatewayNoTemplateSpec, MarshallingWebServiceOutboundGateway> {
        protected Marshaller gatewayMarshaller = new Jaxb2Marshaller();
        protected @Nullable Unmarshaller gatewayUnmarshaller;

        public MarshallingWsOutboundGatewayNoTemplateSpec marshaller(Marshaller marshaller) {
            this.gatewayMarshaller = marshaller;
            return this;
        }

        public MarshallingWsOutboundGatewayNoTemplateSpec unmarshaller(Unmarshaller unmarshaller) {
            this.gatewayUnmarshaller = unmarshaller;
            return this;
        }

        public MarshallingWsOutboundGatewayNoTemplateSpec messageFactory(WebServiceMessageFactory messageFactory) {
            this.webServiceMessageFactory = messageFactory;
            return this;
        }

        public MarshallingWsOutboundGatewayNoTemplateSpec faultMessageResolver(FaultMessageResolver resolver) {
            this.faultMessageResolver = resolver;
            return this;
        }

        public MarshallingWsOutboundGatewayNoTemplateSpec messageSenders(WebServiceMessageSender ... senders) {
            this.messageSenders = Arrays.copyOf(senders, senders.length);
            return this;
        }

        public MarshallingWsOutboundGatewayNoTemplateSpec interceptors(ClientInterceptor ... interceptors) {
            this.gatewayInterceptors = Arrays.copyOf(interceptors, interceptors.length);
            return this;
        }

        @Override
        protected MarshallingWebServiceOutboundGateway create() {
            if (this.destinationProvider != null) {
                return new MarshallingWebServiceOutboundGateway(this.destinationProvider, this.gatewayMarshaller, this.gatewayUnmarshaller, this.webServiceMessageFactory);
            }
            return new MarshallingWebServiceOutboundGateway(this.uri, this.gatewayMarshaller, this.gatewayUnmarshaller, this.webServiceMessageFactory);
        }

        @Override
        protected MarshallingWebServiceOutboundGateway assemble(MarshallingWebServiceOutboundGateway gateway) {
            MarshallingWebServiceOutboundGateway assembled = super.assemble(gateway);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.faultMessageResolver, assembled::setFaultMessageResolver).acceptIfNotNull((Object)this.messageSenders, assembled::setMessageSenders).acceptIfNotNull((Object)this.gatewayInterceptors, assembled::setInterceptors);
            return assembled;
        }
    }
}

