/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.test.context.MockIntegrationContext;
import org.springframework.integration.test.context.SpringIntegrationTest;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.PatternMatchUtils;

class SpringIntegrationTestExecutionListener
implements TestExecutionListener {
    private List<AbstractEndpoint> autoStartupCandidates;

    SpringIntegrationTestExecutionListener() {
    }

    public void prepareTestInstance(TestContext testContext) {
        SpringIntegrationTest springIntegrationTest = (SpringIntegrationTest)TestContextAnnotationUtils.findMergedAnnotation((Class)testContext.getTestClass(), SpringIntegrationTest.class);
        String[] patterns = springIntegrationTest != null ? springIntegrationTest.noAutoStartup() : new String[]{};
        ApplicationContext applicationContext = testContext.getApplicationContext();
        MockIntegrationContext mockIntegrationContext = (MockIntegrationContext)applicationContext.getBean(MockIntegrationContext.class);
        this.autoStartupCandidates = mockIntegrationContext.getAutoStartupCandidates();
        this.autoStartupCandidates.stream().filter(endpoint -> !SpringIntegrationTestExecutionListener.match(endpoint.getBeanName(), patterns)).peek(endpoint -> endpoint.setAutoStartup(true)).forEach(AbstractEndpoint::start);
    }

    public void afterTestClass(TestContext testContext) {
        this.autoStartupCandidates.forEach(AbstractEndpoint::stop);
    }

    private static boolean match(String name, String[] patterns) {
        return patterns.length > 0 && Arrays.stream(patterns).anyMatch(pattern -> PatternMatchUtils.simpleMatch((String)pattern, (String)name));
    }
}

