/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.stream.outbound.CharacterStreamWritingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ConsoleOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CharacterStreamWritingMessageHandler.class);
        if (element.getLocalName().startsWith("stderr")) {
            builder.setFactoryMethod("stderr");
        } else {
            builder.setFactoryMethod("stdout");
        }
        String charsetName = element.getAttribute("charset");
        if (StringUtils.hasText((String)charsetName)) {
            builder.addConstructorArgValue((Object)charsetName);
        }
        if ("true".equals(element.getAttribute("append-newline"))) {
            builder.addPropertyValue("shouldAppendNewLine", (Object)Boolean.TRUE);
        }
        return builder.getBeanDefinition();
    }
}

