/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.stream.StreamClosedEvent;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class CharacterStreamReadingMessageSource
extends AbstractMessageSource<String>
implements ApplicationEventPublisherAware {
    private final Lock lock = new ReentrantLock();
    private final BufferedReader reader;
    private final boolean blockToDetectEOF;
    private ApplicationEventPublisher applicationEventPublisher;

    public CharacterStreamReadingMessageSource(Reader reader) {
        this(reader, -1, false);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize) {
        this(reader, bufferSize, false);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize, boolean blockToDetectEOF) {
        BufferedReader bufferedReader;
        Assert.notNull((Object)reader, (String)"reader must not be null");
        this.reader = reader instanceof BufferedReader ? (bufferedReader = (BufferedReader)reader) : (bufferSize > 0 ? new BufferedReader(reader, bufferSize) : new BufferedReader(reader));
        this.blockToDetectEOF = blockToDetectEOF;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public String getComponentType() {
        return "stream:stdin-channel-adapter(character)";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doReceive() {
        try {
            this.lock.lock();
            try {
                if (!this.blockToDetectEOF && !this.reader.ready()) {
                    String string = null;
                    return string;
                }
                String line = this.reader.readLine();
                if (line == null && this.applicationEventPublisher != null) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StreamClosedEvent((Object)this));
                }
                String string = line;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }

    public static CharacterStreamReadingMessageSource stdin() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in));
    }

    public static CharacterStreamReadingMessageSource stdin(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }

    public static CharacterStreamReadingMessageSource stdinPipe() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in), -1, true);
    }

    public static CharacterStreamReadingMessageSource stdinPipe(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName), -1, true);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

