/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.stomp.support.StompHeaderMapper;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class StompAdapterParserUtils {
    StompAdapterParserUtils() {
    }

    static void configureStompAdapter(BeanDefinitionBuilder builder, ParserContext parserContext, Element element) {
        String stompSessionManager = element.getAttribute("stomp-session-manager");
        if (!StringUtils.hasText((String)stompSessionManager)) {
            parserContext.getReaderContext().error("The 'stomp-session-manager' is required", (Object)element);
        }
        builder.addConstructorArgReference(stompSessionManager);
        String headerMapper = element.getAttribute("header-mapper");
        String mappedHeaders = element.getAttribute("mapped-headers");
        boolean hasMappedHeaders = StringUtils.hasText((String)mappedHeaders);
        if (StringUtils.hasText((String)headerMapper)) {
            if (hasMappedHeaders) {
                parserContext.getReaderContext().error("The 'mapped-headers' attribute is not allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else if (hasMappedHeaders) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(StompHeaderMapper.class);
            headerMapperBuilder.addPropertyValue("inboundHeaderNames", (Object)mappedHeaders);
            headerMapperBuilder.addPropertyValue("outboundHeaderNames", (Object)mappedHeaders);
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
    }
}

