/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.jsr223;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.scripting.PolyglotScriptExecutor;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.jsr223.DefaultScriptExecutor;
import org.springframework.integration.scripting.jsr223.RubyScriptExecutor;
import org.springframework.util.Assert;

public final class ScriptExecutorFactory {
    private static final Log LOGGER = LogFactory.getLog(ScriptExecutorFactory.class);

    public static ScriptExecutor getScriptExecutor(String language) {
        if (language.equalsIgnoreCase("jython")) {
            LOGGER.warn((Object)"The 'jython' language indicator is deprecated and will be removed in the next version.\nThe Python support is fully based on GraalVM Polyglot and there is no 'jython' dependency requirement any more.\n");
            return new PolyglotScriptExecutor("python");
        }
        if (language.equalsIgnoreCase("python")) {
            return new PolyglotScriptExecutor("python");
        }
        if (language.equalsIgnoreCase("ruby") || language.equalsIgnoreCase("jruby")) {
            return new RubyScriptExecutor();
        }
        if (language.equalsIgnoreCase("js") || language.equalsIgnoreCase("javascript")) {
            return new PolyglotScriptExecutor("js");
        }
        return new DefaultScriptExecutor(language);
    }

    public static String deriveLanguageFromFileExtension(String scriptLocation) {
        String extension;
        int index = scriptLocation.lastIndexOf(46) + 1;
        Assert.state((index > 0 ? 1 : 0) != 0, () -> "Unable to determine language for script '" + scriptLocation + "'");
        switch (extension = scriptLocation.substring(index)) {
            case "kts": {
                return "kotlin";
            }
            case "js": {
                return "js";
            }
            case "py": {
                return "python";
            }
        }
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine engine = engineManager.getEngineByExtension(extension);
        Assert.state((engine != null ? 1 : 0) != 0, () -> "No suitable scripting engine found for extension '" + extension + "'");
        return engine.getFactory().getLanguageName();
    }

    private ScriptExecutorFactory() {
    }
}

