/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.rsocket.outbound.RSocketOutboundGateway;
import org.w3c.dom.Element;

public class RSocketOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RSocketOutboundGateway.class);
        BeanDefinition routeExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"route", (String)"route-expression", (ParserContext)parserContext, (Element)element, (boolean)true);
        builder.addConstructorArgValue((Object)routeExpression);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"client-rsocket-connector", (String)"clientRSocketConnector");
        RSocketOutboundGatewayParser.populateValueOrExpressionIfAny(builder, element, parserContext, "interaction-model");
        RSocketOutboundGatewayParser.populateValueOrExpressionIfAny(builder, element, parserContext, "command");
        RSocketOutboundGatewayParser.populateValueOrExpressionIfAny(builder, element, parserContext, "publisher-element-type");
        RSocketOutboundGatewayParser.populateValueOrExpressionIfAny(builder, element, parserContext, "expected-response-type");
        RSocketOutboundGatewayParser.populateValueOrExpressionIfAny(builder, element, parserContext, "metadata");
        return builder;
    }

    private static void populateValueOrExpressionIfAny(BeanDefinitionBuilder builder, Element element, ParserContext parserContext, String valueAttributeName) {
        String expressionAttributeName = valueAttributeName + "-expression";
        BeanDefinition expression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)valueAttributeName, (String)expressionAttributeName, (ParserContext)parserContext, (Element)element, (boolean)false);
        if (expression != null) {
            builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)expressionAttributeName), (Object)expression);
        }
    }
}

