/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.inbound;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.collections.RedisCollectionFactoryBean;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class RedisStoreMessageSource
extends AbstractMessageSource<RedisStore> {
    private final RedisTemplate<String, ?> redisTemplate;
    private final Expression keyExpression;
    private StandardEvaluationContext evaluationContext;
    private RedisCollectionFactoryBean.CollectionType collectionType = RedisCollectionFactoryBean.CollectionType.LIST;

    public RedisStoreMessageSource(RedisTemplate<String, ?> redisTemplate, Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        this.redisTemplate = redisTemplate;
        this.keyExpression = keyExpression;
    }

    public RedisStoreMessageSource(RedisConnectionFactory connectionFactory, Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.redisTemplate = new StringRedisTemplate();
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.afterPropertiesSet();
        this.keyExpression = keyExpression;
    }

    public void setCollectionType(RedisCollectionFactoryBean.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected @Nullable RedisStore doReceive() {
        String key = (String)this.keyExpression.getValue((EvaluationContext)this.evaluationContext, String.class);
        Assert.hasText((String)key, (String)"Failed to determine the key for the collection");
        RedisStore store = this.createStoreView(key);
        Object holder = TransactionSynchronizationManager.getResource((Object)((Object)this));
        if (holder != null) {
            Assert.isInstanceOf(IntegrationResourceHolder.class, (Object)holder);
            ((IntegrationResourceHolder)holder).addAttribute("store", (Object)store);
        }
        if (store instanceof Collection && ((Collection)store).size() < 1) {
            return null;
        }
        return store;
    }

    private RedisStore createStoreView(String key) {
        RedisCollectionFactoryBean fb = new RedisCollectionFactoryBean();
        fb.setKey(key);
        fb.setTemplate(this.redisTemplate);
        fb.setType(this.collectionType);
        fb.afterPropertiesSet();
        return fb.getObject();
    }

    public String getComponentType() {
        return "redis:store-inbound-channel-adapter";
    }
}

