/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.channel.SubscribableRedisChannel;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisChannelParser
extends AbstractChannelParser {
    protected BeanDefinitionBuilder buildBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SubscribableRedisChannel.class);
        String connectionFactory = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactory)) {
            connectionFactory = "redisConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactory);
        String topicName = element.getAttribute("topic-name");
        builder.addConstructorArgValue((Object)topicName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-subscribers");
        return builder;
    }
}

