/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.outbound.RedisStoreWritingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisStoreOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        String mapKeyExpression;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisStoreWritingMessageHandler.class);
        String redisTemplateRef = element.getAttribute("redis-template");
        String connectionFactory = element.getAttribute("connection-factory");
        if (StringUtils.hasText((String)redisTemplateRef) && StringUtils.hasText((String)connectionFactory)) {
            parserContext.getReaderContext().error("Only one of 'redis-template' or 'connection-factory' is allowed.", (Object)element);
        }
        if (StringUtils.hasText((String)redisTemplateRef)) {
            builder.addConstructorArgReference(redisTemplateRef);
        } else {
            if (!StringUtils.hasText((String)connectionFactory)) {
                connectionFactory = "redisConnectionFactory";
            }
            builder.addConstructorArgReference(connectionFactory);
        }
        boolean hasKey = element.hasAttribute("key");
        boolean hasKeyExpression = element.hasAttribute("key-expression");
        if (hasKey && hasKeyExpression) {
            parserContext.getReaderContext().error("At most one of 'key' or 'key-expression' is allowed.", (Object)element);
        }
        if (hasKey) {
            builder.addPropertyValue("key", (Object)new TypedStringValue(element.getAttribute("key")));
        }
        if (hasKeyExpression) {
            builder.addPropertyValue("keyExpressionString", (Object)element.getAttribute("key-expression"));
        }
        if (StringUtils.hasText((String)(mapKeyExpression = element.getAttribute("map-key-expression")))) {
            builder.addPropertyValue("mapKeyExpressionString", (Object)mapKeyExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"collection-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload-elements");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"zset-increment-expression", (String)"zsetIncrementExpressionString");
        return builder.getBeanDefinition();
    }
}

