/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.store;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.store.ChannelMessageStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupFactory;
import org.springframework.integration.store.SimpleMessageGroupFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RedisChannelMessageStore
implements ChannelMessageStore,
BeanNameAware,
InitializingBean {
    private final RedisTemplate<Object, Message<?>> redisTemplate;
    private volatile MessageGroupFactory messageGroupFactory = new SimpleMessageGroupFactory();
    private String beanName;

    public RedisChannelMessageStore(RedisConnectionFactory connectionFactory) {
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        this.redisTemplate.afterPropertiesSet();
    }

    public void setValueSerializer(RedisSerializer<?> valueSerializer) {
        Assert.notNull(valueSerializer, (String)"'valueSerializer' must not be null");
        this.redisTemplate.setValueSerializer(valueSerializer);
    }

    public void setMessageGroupFactory(MessageGroupFactory messageGroupFactory) {
        Assert.notNull((Object)messageGroupFactory, (String)"'messageGroupFactory' must not be null");
        this.messageGroupFactory = messageGroupFactory;
    }

    protected MessageGroupFactory getMessageGroupFactory() {
        return this.messageGroupFactory;
    }

    public void setBeanName(String name) {
        Assert.notNull((Object)name, (String)"'beanName' must not be null");
        this.beanName = name;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    protected RedisTemplate<Object, Message<?>> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanName, (String)"'beanName' must not be null");
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        return (int)this.redisTemplate.boundListOps(groupId).size().longValue();
    }

    public MessageGroup getMessageGroup(Object groupId) {
        List messages = this.redisTemplate.boundListOps(groupId).range(0L, -1L);
        return this.getMessageGroupFactory().create((Collection)messages, groupId);
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        this.redisTemplate.boundListOps(groupId).leftPush(message);
        return null;
    }

    public void removeMessageGroup(Object groupId) {
        this.redisTemplate.boundListOps(groupId).trim(1L, 0L);
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        return (Message)this.redisTemplate.boundListOps(groupId).rightPop();
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Set keys = this.redisTemplate.keys((Object)(this.beanName + ":*"));
        int count = 0;
        for (Object key : keys) {
            count += this.messageGroupSize(key);
        }
        return count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        return this.redisTemplate.keys((Object)(this.beanName + ":*")).size();
    }
}

