/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import java.util.ArrayList;
import java.util.LinkedList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.redis.outbound.ArgumentsStrategy;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ExpressionArgumentsStrategy
implements ArgumentsStrategy,
BeanFactoryAware,
InitializingBean {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Expression[] argumentExpressions;
    private EvaluationContext evaluationContext;
    private final boolean useCommandVariable;
    private BeanFactory beanFactory;

    public ExpressionArgumentsStrategy(String[] argumentExpressions) {
        this(argumentExpressions, false);
    }

    public ExpressionArgumentsStrategy(String[] argumentExpressions, boolean useCommandVariable) {
        Assert.notNull((Object)argumentExpressions, (String)"'argumentExpressions' must not be null");
        Assert.noNullElements((Object[])argumentExpressions, (String)"'argumentExpressions' cannot have null values.");
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        for (String argumentExpression : argumentExpressions) {
            expressions.add(PARSER.parseExpression(argumentExpression));
        }
        this.argumentExpressions = expressions.toArray(new Expression[expressions.size()]);
        this.useCommandVariable = useCommandVariable;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
    }

    @Override
    public Object[] resolve(String command, Message<?> message) {
        EvaluationContext evaluationContext = this.evaluationContext;
        if (this.useCommandVariable) {
            evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.beanFactory);
            evaluationContext.setVariable("cmd", (Object)command);
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Expression argumentExpression : this.argumentExpressions) {
            Object argument = argumentExpression.getValue(evaluationContext, message);
            if (argument == null) continue;
            arguments.add(argument);
        }
        return arguments.toArray();
    }
}

