/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.r2dbc.inbound;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.r2dbc.convert.EntityRowMapper;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.r2dbc.core.ColumnMapRowMapper;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class R2dbcMessageSource
extends AbstractMessageSource<Publisher<?>> {
    private final R2dbcEntityOperations r2dbcEntityOperations;
    private final DatabaseClient databaseClient;
    private final StatementMapper statementMapper;
    private final SelectCreator selectCreator = new SelectCreator();
    private final Expression queryExpression;
    private Class<?> payloadType = Map.class;
    private BiFunction<Row, RowMetadata, ?> rowMapper = ColumnMapRowMapper.INSTANCE;
    private boolean expectSingleResult = false;
    private StandardEvaluationContext evaluationContext;
    private String updateSql;
    private BiFunction<DatabaseClient.GenericExecuteSpec, Object, DatabaseClient.GenericExecuteSpec> bindFunction;
    private volatile boolean initialized = false;

    public R2dbcMessageSource(R2dbcEntityOperations r2dbcEntityOperations, String query) {
        this(r2dbcEntityOperations, (Expression)new LiteralExpression(query));
    }

    public R2dbcMessageSource(R2dbcEntityOperations r2dbcEntityOperations, Expression queryExpression) {
        Assert.notNull((Object)r2dbcEntityOperations, (String)"'r2dbcEntityOperations' must not be null");
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.r2dbcEntityOperations = r2dbcEntityOperations;
        this.databaseClient = r2dbcEntityOperations.getDatabaseClient();
        this.statementMapper = r2dbcEntityOperations.getDataAccessStrategy().getStatementMapper();
        this.queryExpression = queryExpression;
    }

    public void setPayloadType(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"'payloadType' must not be null");
        this.payloadType = payloadType;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setBindFunction(BiFunction<DatabaseClient.GenericExecuteSpec, ?, DatabaseClient.GenericExecuteSpec> bindFunction) {
        this.bindFunction = bindFunction;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public String getComponentType() {
        return "r2dbc:inbound-channel-adapter";
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (!Map.class.isAssignableFrom(this.payloadType)) {
            this.rowMapper = new EntityRowMapper(this.payloadType, this.r2dbcEntityOperations.getConverter());
        }
        this.initialized = true;
    }

    protected Object doReceive() {
        Assert.isTrue((boolean)this.initialized, (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        Mono queryMono = Mono.fromSupplier(() -> this.queryExpression.getValue((EvaluationContext)this.evaluationContext, (Object)this.selectCreator)).map(this::prepareFetch);
        if (this.expectSingleResult) {
            return queryMono.flatMap(RowsFetchSpec::one).flatMap(this::executeUpdate);
        }
        return queryMono.flatMapMany(RowsFetchSpec::all).flatMap(this::executeUpdate);
    }

    private Mono<Object> executeUpdate(Object result) {
        if (this.updateSql != null) {
            DatabaseClient.GenericExecuteSpec genericExecuteSpec = this.databaseClient.sql(this.updateSql);
            if (this.bindFunction != null) {
                genericExecuteSpec = this.bindFunction.apply(genericExecuteSpec, result);
            }
            return genericExecuteSpec.then().thenReturn(result);
        }
        return Mono.just((Object)result);
    }

    private RowsFetchSpec<?> prepareFetch(Object queryObject) {
        Supplier<String> query = this.evaluateQueryObject(queryObject);
        return this.databaseClient.sql(query).map(this.rowMapper);
    }

    private Supplier<String> evaluateQueryObject(Object queryObject) {
        if (queryObject instanceof String) {
            return () -> (String)queryObject;
        }
        if (queryObject instanceof StatementMapper.SelectSpec) {
            return this.statementMapper.getMappedObject((StatementMapper.SelectSpec)queryObject);
        }
        throw new IllegalStateException("'queryExpression' must evaluate to String or org.springframework.data.r2dbc.core.StatementMapper.SelectSpec, but not: " + queryObject);
    }

    public class SelectCreator {
        SelectCreator() {
        }

        public StatementMapper.SelectSpec createSelect(String table) {
            return R2dbcMessageSource.this.statementMapper.createSelect(table);
        }

        public StatementMapper.SelectSpec createSelect(SqlIdentifier table) {
            return R2dbcMessageSource.this.statementMapper.createSelect(table);
        }
    }
}

