/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.config.xml;

import java.util.Objects;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class MqttParserUtils {
    private MqttParserUtils() {
    }

    static void parseCommon(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        ConstructorArgumentValues.ValueHolder holder;
        int n = 0;
        String url = element.getAttribute("url");
        if (StringUtils.hasText((String)url)) {
            builder.addConstructorArgValue((Object)url);
            holder = (ConstructorArgumentValues.ValueHolder)builder.getRawBeanDefinition().getConstructorArgumentValues().getIndexedArgumentValues().get(n++);
            Objects.requireNonNull(holder).setType("java.lang.String");
        }
        builder.addConstructorArgValue((Object)element.getAttribute("client-id"));
        holder = (ConstructorArgumentValues.ValueHolder)builder.getRawBeanDefinition().getConstructorArgumentValues().getIndexedArgumentValues().get(n);
        Objects.requireNonNull(holder).setType("java.lang.String");
        String clientFactory = element.getAttribute("client-factory");
        if (StringUtils.hasText((String)clientFactory)) {
            builder.addConstructorArgReference(clientFactory);
        } else {
            if (!StringUtils.hasText((String)url)) {
                parserContext.getReaderContext().error("If no 'url' attribute is provided, a 'client-factory' (with serverURIs) is required", (Object)element);
            }
            builder.addConstructorArgValue((Object)new RootBeanDefinition(DefaultMqttPahoClientFactory.class));
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"converter");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout");
    }
}

