/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mongodb.config.MongoParserUtils;
import org.springframework.integration.mongodb.outbound.MongoDbOutboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MongoDbOutboundGateway.class);
        MongoParserUtils.processCommonAttributes(element, parserContext, builder);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        String collectionCallback = element.getAttribute("collection-callback");
        if (StringUtils.hasText((String)collectionCallback)) {
            if (StringUtils.hasText((String)element.getAttribute("query")) || StringUtils.hasText((String)element.getAttribute("query-expression"))) {
                parserContext.getReaderContext().error("'collection-callback' is not allowed with 'query' or 'query-expression'", (Object)element);
            }
            builder.addPropertyReference("messageCollectionCallback", collectionCallback);
        } else {
            BeanDefinition queryExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"query", (String)"query-expression", (ParserContext)parserContext, (Element)element, (boolean)true);
            if (queryExpressionDef != null) {
                builder.addPropertyValue("queryExpression", (Object)queryExpressionDef);
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"expect-single-result");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"entity-class");
        return builder;
    }

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }
}

