/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.mongodb.support.BinaryToMessageConverter;
import org.springframework.integration.mongodb.support.MessageToBinaryConverter;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageMetadata;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractConfigurableMongoDbMessageStore
extends AbstractMessageGroupStore
implements InitializingBean,
ApplicationContextAware {
    public static final String SEQUENCE_NAME = "messagesSequence";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final RuntimeException NOT_IMPLEMENTED = new UnsupportedOperationException("The operation isn't implemented for this class.");
    protected final String collectionName;
    protected final MongoDbFactory mongoDbFactory;
    private MongoTemplate mongoTemplate;
    private MappingMongoConverter mappingMongoConverter;
    private ApplicationContext applicationContext;
    private MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public AbstractConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        Assert.hasText((String)collectionName, (String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoTemplate = mongoTemplate;
        this.mongoDbFactory = null;
    }

    public AbstractConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public AbstractConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        Assert.notNull((Object)mongoDbFactory, (String)"'mongoDbFactory' must not be null");
        Assert.hasText((String)collectionName, (String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoDbFactory = mongoDbFactory;
        this.mappingMongoConverter = mappingMongoConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    protected MappingMongoConverter getMappingMongoConverter() {
        return this.mappingMongoConverter;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void afterPropertiesSet() {
        if (this.mongoTemplate == null) {
            if (this.mappingMongoConverter == null) {
                this.mappingMongoConverter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(this.mongoDbFactory), (MappingContext)new MongoMappingContext());
                this.mappingMongoConverter.setApplicationContext(this.applicationContext);
                ArrayList<Object> customConverters = new ArrayList<Object>();
                customConverters.add(new MessageToBinaryConverter());
                customConverters.add(new BinaryToMessageConverter());
                this.mappingMongoConverter.setCustomConversions((CustomConversions)new MongoCustomConversions(customConverters));
                this.mappingMongoConverter.afterPropertiesSet();
            }
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, (MongoConverter)this.mappingMongoConverter);
        }
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.applicationContext);
        IndexOperations indexOperations = this.mongoTemplate.indexOps(this.collectionName);
        indexOperations.ensureIndex((IndexDefinition)new Index("messageId", Sort.Direction.ASC));
        indexOperations.ensureIndex((IndexDefinition)new Index("groupId", Sort.Direction.ASC).on("messageId", Sort.Direction.ASC).unique());
        indexOperations.ensureIndex((IndexDefinition)new Index("groupId", Sort.Direction.ASC).on("lastModifiedTime", Sort.Direction.DESC).on("sequence", Sort.Direction.DESC));
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)id));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public MessageMetadata getMessageMetadata(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)id));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        if (document != null) {
            MessageMetadata messageMetadata = new MessageMetadata(id);
            messageMetadata.setTimestamp(document.getCreatedTime().longValue());
            return messageMetadata;
        }
        return null;
    }

    public void removeMessageGroup(Object groupId) {
        this.mongoTemplate.remove(AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.mongoTemplate.count(AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    protected int getNextId() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)SEQUENCE_NAME));
        query.fields().include("sequence");
        return (Integer)((Map)this.mongoTemplate.findAndModify(query, new Update().inc("sequence", (Number)1), FindAndModifyOptions.options().returnNew(true).upsert(true), Map.class, this.collectionName)).get("sequence");
    }

    protected void addMessageDocument(MessageDocument document) {
        block3: {
            if (document.getGroupCreatedTime() == 0L) {
                document.setGroupCreatedTime(System.currentTimeMillis());
            }
            document.setCreatedTime(System.currentTimeMillis());
            try {
                this.mongoTemplate.insert((Object)document, this.collectionName);
            }
            catch (DuplicateKeyException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("The Message with id [" + document.getMessageId() + "] already exists.\nIgnoring INSERT and SELECT existing..."));
            }
        }
    }

    protected static Query groupIdQuery(Object groupId) {
        return Query.query((CriteriaDefinition)Criteria.where((String)"groupId").is(groupId));
    }

    public void removeMessagesFromGroup(Object key, Collection<Message<?>> messages) {
        throw NOT_IMPLEMENTED;
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        throw NOT_IMPLEMENTED;
    }

    public Iterator<MessageGroup> iterator() {
        throw NOT_IMPLEMENTED;
    }

    public void completeGroup(Object groupId) {
        throw NOT_IMPLEMENTED;
    }

    public Message<?> getOneMessageFromGroup(Object groupId) {
        throw NOT_IMPLEMENTED;
    }

    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        throw NOT_IMPLEMENTED;
    }

    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        throw NOT_IMPLEMENTED;
    }
}

