/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.outbound;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mapping.MessageMappingException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MailSendingMessageHandler
extends AbstractMessageHandler {
    private final MailSender mailSender;

    public MailSendingMessageHandler(MailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"'mailSender' must not be null");
        this.mailSender = mailSender;
    }

    public String getComponentType() {
        return "mail:outbound-channel-adapter";
    }

    protected final void handleMessageInternal(Message<?> message) {
        MailMessage mailMessage = this.convertMessageToMailMessage(message);
        if (mailMessage instanceof SimpleMailMessage) {
            SimpleMailMessage simpleMailMessage = (SimpleMailMessage)mailMessage;
            this.mailSender.send(simpleMailMessage);
        } else if (mailMessage instanceof MimeMailMessage) {
            MimeMailMessage mimeMailMessage = (MimeMailMessage)mailMessage;
            Assert.state((boolean)(this.mailSender instanceof JavaMailSender), (String)"this adapter requires a 'JavaMailSender' to send a 'MimeMailMessage'");
            ((JavaMailSender)this.mailSender).send(mimeMailMessage.getMimeMessage());
        } else {
            throw new IllegalArgumentException("Unsupported MailMessage type [" + mailMessage.getClass().getName() + "].");
        }
    }

    private MailMessage convertMessageToMailMessage(Message<?> message) {
        MimeMailMessage mailMessage;
        Object payload = message.getPayload();
        if (payload instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)payload;
            mailMessage = new MimeMailMessage(mimeMessage);
        } else if (payload instanceof MailMessage) {
            MailMessage mailMsg = (MailMessage)payload;
            mailMessage = mailMsg;
        } else if (payload instanceof byte[]) {
            mailMessage = this.createMailMessageFromByteArrayMessage(message);
        } else if (payload instanceof String) {
            String contentType = (String)message.getHeaders().get((Object)"mail_contentType");
            if (StringUtils.hasText((String)contentType)) {
                mailMessage = this.createMailMessageWithContentType(message, contentType);
            } else {
                mailMessage = new SimpleMailMessage();
                mailMessage.setText((String)payload);
            }
        } else {
            throw new IllegalArgumentException("Unable to create MailMessage from payload type [" + message.getPayload().getClass().getName() + "], expected MimeMessage, MailMessage, byte array or String.");
        }
        MailSendingMessageHandler.applyHeadersToMailMessage((MailMessage)mailMessage, message.getHeaders());
        return mailMessage;
    }

    private MailMessage createMailMessageWithContentType(Message<String> message, String contentType) {
        Assert.state((boolean)(this.mailSender instanceof JavaMailSender), (String)"this adapter requires a 'JavaMailSender' to send a 'MimeMailMessage'");
        MimeMessage mimeMessage = ((JavaMailSender)this.mailSender).createMimeMessage();
        try {
            mimeMessage.setContent(message.getPayload(), contentType);
            return new MimeMailMessage(mimeMessage);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create MimeMessage with contentType: " + contentType, e);
        }
    }

    private MailMessage createMailMessageFromByteArrayMessage(Message<byte[]> message) {
        Assert.state((boolean)(this.mailSender instanceof JavaMailSender), (String)"this adapter requires a 'JavaMailSender' to send a 'MimeMailMessage'");
        MessageHeaders headers = message.getHeaders();
        String attachmentFileName = (String)headers.get((Object)"mail_attachmentFilename", String.class);
        if (attachmentFileName == null) {
            throw new MessageMappingException(message, "Header 'mail_attachmentFilename' is required when mapping a Message with a byte array payload to a MailMessage.");
        }
        Integer multipartMode = (Integer)headers.get((Object)"mail_multipartMode", Integer.class);
        if (multipartMode == null) {
            multipartMode = 1;
        }
        MimeMessage mimeMessage = ((JavaMailSender)this.mailSender).createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, multipartMode.intValue());
            helper.addAttachment(attachmentFileName, (InputStreamSource)new ByteArrayResource((byte[])message.getPayload()));
            return new MimeMailMessage(helper);
        }
        catch (MessagingException e) {
            throw new MessageMappingException(message, "failed to create MimeMessage", (Throwable)e);
        }
    }

    private static void applyHeadersToMailMessage(MailMessage mailMessage, MessageHeaders headers) {
        String replyTo;
        String from;
        String[] bcc;
        String[] cc;
        String[] to;
        String subject = (String)headers.get((Object)"mail_subject", String.class);
        if (subject != null) {
            mailMessage.setSubject(subject);
        }
        if ((to = MailSendingMessageHandler.retrieveHeaderValueAsStringArray(headers, "mail_to")) != null) {
            mailMessage.setTo(to);
        }
        if (mailMessage instanceof SimpleMailMessage) {
            SimpleMailMessage simpleMailMessage = (SimpleMailMessage)mailMessage;
            Assert.state((!ObjectUtils.isEmpty((Object[])simpleMailMessage.getTo()) ? 1 : 0) != 0, (String)"No recipient has been provided on the MailMessage or the 'MailHeaders.TO' header.");
        }
        if ((cc = MailSendingMessageHandler.retrieveHeaderValueAsStringArray(headers, "mail_cc")) != null) {
            mailMessage.setCc(cc);
        }
        if ((bcc = MailSendingMessageHandler.retrieveHeaderValueAsStringArray(headers, "mail_bcc")) != null) {
            mailMessage.setBcc(bcc);
        }
        if ((from = (String)headers.get((Object)"mail_from", String.class)) != null) {
            mailMessage.setFrom(from);
        }
        if ((replyTo = (String)headers.get((Object)"mail_replyTo", String.class)) != null) {
            mailMessage.setReplyTo(replyTo);
        }
    }

    private static String @Nullable [] retrieveHeaderValueAsStringArray(MessageHeaders headers, String key) {
        Object value = headers.get((Object)key);
        String[] returnedHeaders = null;
        if (value != null) {
            if (value instanceof String[]) {
                @Nullable String[] strArr = (String[])value;
                returnedHeaders = (String[])Arrays.stream(strArr).filter(Objects::nonNull).toArray(String[]::new);
            } else if (value instanceof String) {
                returnedHeaders = StringUtils.commaDelimitedListToStringArray((String)((String)value));
            }
        }
        if (returnedHeaders == null || ObjectUtils.isEmpty(returnedHeaders)) {
            returnedHeaders = null;
        }
        return returnedHeaders;
    }
}

