/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.mail.outbound.MailSendingMessageHandler;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MailOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailSendingMessageHandler.class);
        String mailSenderRef = element.getAttribute("mail-sender");
        String host = element.getAttribute("host");
        boolean hasHost = StringUtils.hasText((String)host);
        String port = element.getAttribute("port");
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        String javaMailProperties = element.getAttribute("java-mail-properties");
        boolean hasJavaMailProperties = StringUtils.hasText((String)javaMailProperties);
        if (StringUtils.hasText((String)mailSenderRef)) {
            Assert.isTrue((!hasHost && !StringUtils.hasText((String)username) && !StringUtils.hasText((String)password) ? 1 : 0) != 0, (String)"The 'host', 'username', and 'password' properties should not be provided when using a 'mail-sender' reference.");
            builder.addConstructorArgReference(mailSenderRef);
        } else {
            Assert.isTrue((!hasHost || !hasJavaMailProperties ? 1 : 0) != 0, (String)"Either a 'mail-sender' or 'java-mail-properties' reference or 'host' property is required.");
            BeanDefinitionBuilder mailSenderBuilder = BeanDefinitionBuilder.genericBeanDefinition(JavaMailSenderImpl.class);
            if (hasHost) {
                mailSenderBuilder.addPropertyValue("host", (Object)host);
            }
            if (StringUtils.hasText((String)username)) {
                mailSenderBuilder.addPropertyValue("username", (Object)username);
            }
            if (StringUtils.hasText((String)password)) {
                mailSenderBuilder.addPropertyValue("password", (Object)password);
            }
            if (StringUtils.hasText((String)port)) {
                mailSenderBuilder.addPropertyValue("port", (Object)port);
            }
            if (hasJavaMailProperties) {
                mailSenderBuilder.addPropertyReference("javaMailProperties", javaMailProperties);
            }
            String mailSenderBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mailSenderBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            builder.addConstructorArgReference(mailSenderBeanName);
        }
        return builder.getBeanDefinition();
    }
}

