/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.support;

import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import org.springframework.integration.mail.support.MailUtils;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.LinkedMultiValueMap;

public class DefaultMailHeaderMapper
implements HeaderMapper<MimeMessage> {
    public void fromHeaders(MessageHeaders headers, MimeMessage target) {
        throw new UnsupportedOperationException("Mapping to a mail message is not currently supported");
    }

    public Map<String, Object> toHeaders(MimeMessage source) {
        Map<String, Object> headers = MailUtils.extractStandardHeaders((Message)source);
        try {
            int size;
            Date receivedDate;
            Enumeration allHeaders = source.getAllHeaders();
            LinkedMultiValueMap rawHeaders = new LinkedMultiValueMap();
            while (allHeaders.hasMoreElements()) {
                Object headerInstance = allHeaders.nextElement();
                if (!(headerInstance instanceof Header)) continue;
                Header header = (Header)headerInstance;
                rawHeaders.add((Object)header.getName(), (Object)header.getValue());
            }
            headers.put("mail_raw", rawHeaders);
            headers.put("mail_flags", source.getFlags());
            int lineCount = source.getLineCount();
            if (lineCount > 0) {
                headers.put("mail_lineCount", lineCount);
            }
            if ((receivedDate = source.getReceivedDate()) != null) {
                headers.put("mail_receivedDate", receivedDate);
            }
            if ((size = source.getSize()) > 0) {
                headers.put("mail_size", size);
            }
            headers.put("mail_expunged", source.isExpunged());
            headers.put("mail_contentType", source.getContentType());
        }
        catch (Exception e) {
            throw new MessagingException("Failed to map message headers", (Throwable)e);
        }
        return headers;
    }
}

