/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.dsl;

import java.util.function.Function;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.support.MapBuilder;
import org.springframework.messaging.Message;

public class MailHeadersBuilder
extends MapBuilder<MailHeadersBuilder, String, Object> {
    public MailHeadersBuilder subject(String subject) {
        return (MailHeadersBuilder)this.put("mail_subject", subject);
    }

    public MailHeadersBuilder subjectExpression(String subject) {
        return this.putExpression("mail_subject", subject);
    }

    public <P> MailHeadersBuilder subjectFunction(Function<Message<P>, String> subject) {
        return (MailHeadersBuilder)this.put("mail_subject", new FunctionExpression(subject));
    }

    public MailHeadersBuilder to(String ... to) {
        return (MailHeadersBuilder)this.put("mail_to", to);
    }

    public MailHeadersBuilder toExpression(String to) {
        return this.putExpression("mail_to", to);
    }

    public <P> MailHeadersBuilder toFunction(Function<Message<P>, String[]> to) {
        return (MailHeadersBuilder)this.put("mail_to", new FunctionExpression(to));
    }

    public MailHeadersBuilder cc(String ... cc) {
        return (MailHeadersBuilder)this.put("mail_cc", cc);
    }

    public MailHeadersBuilder ccExpression(String cc) {
        return this.putExpression("mail_cc", cc);
    }

    public <P> MailHeadersBuilder ccFunction(Function<Message<P>, String[]> cc) {
        return (MailHeadersBuilder)this.put("mail_cc", new FunctionExpression(cc));
    }

    public MailHeadersBuilder bcc(String ... bcc) {
        return (MailHeadersBuilder)this.put("mail_bcc", bcc);
    }

    public MailHeadersBuilder bccExpression(String bcc) {
        return this.putExpression("mail_bcc", bcc);
    }

    public <P> MailHeadersBuilder bccFunction(Function<Message<P>, String[]> bcc) {
        return (MailHeadersBuilder)this.put("mail_bcc", new FunctionExpression(bcc));
    }

    public MailHeadersBuilder from(String from) {
        return (MailHeadersBuilder)this.put("mail_from", from);
    }

    public MailHeadersBuilder fromExpression(String from) {
        return this.putExpression("mail_from", from);
    }

    public <P> MailHeadersBuilder fromFunction(Function<Message<P>, String> from) {
        return (MailHeadersBuilder)this.put("mail_from", new FunctionExpression(from));
    }

    public MailHeadersBuilder replyTo(String replyTo) {
        return (MailHeadersBuilder)this.put("mail_replyTo", replyTo);
    }

    public MailHeadersBuilder replyToExpression(String replyTo) {
        return this.putExpression("mail_replyTo", replyTo);
    }

    public <P> MailHeadersBuilder replyToFunction(Function<Message<P>, String> replyTo) {
        return (MailHeadersBuilder)this.put("mail_replyTo", new FunctionExpression(replyTo));
    }

    public MailHeadersBuilder multipartMode(int multipartMode) {
        return (MailHeadersBuilder)this.put("mail_multipartMode", multipartMode);
    }

    public MailHeadersBuilder multipartModeExpression(String multipartMode) {
        return this.putExpression("mail_multipartMode", multipartMode);
    }

    public <P> MailHeadersBuilder multipartModeFunction(Function<Message<P>, Integer> multipartMode) {
        return (MailHeadersBuilder)this.put("mail_multipartMode", new FunctionExpression(multipartMode));
    }

    public MailHeadersBuilder attachmentFilename(String attachmentFilename) {
        return (MailHeadersBuilder)this.put("mail_attachmentFilename", attachmentFilename);
    }

    public MailHeadersBuilder attachmentFilenameExpression(String attachmentFilename) {
        return this.putExpression("mail_attachmentFilename", attachmentFilename);
    }

    public <P> MailHeadersBuilder attachmentFilenameFunction(Function<Message<P>, String> attachmentFilename) {
        return (MailHeadersBuilder)this.put("mail_attachmentFilename", new FunctionExpression(attachmentFilename));
    }

    public MailHeadersBuilder contentType(String contentType) {
        return (MailHeadersBuilder)this.put("mail_contentType", contentType);
    }

    public MailHeadersBuilder contentTypeExpression(String contentType) {
        return this.putExpression("mail_contentType", contentType);
    }

    public <P> MailHeadersBuilder contentTypeFunction(Function<Message<P>, String> contentType) {
        return (MailHeadersBuilder)this.put("mail_contentType", new FunctionExpression(contentType));
    }

    private MailHeadersBuilder putExpression(String key, String expression) {
        return (MailHeadersBuilder)this.put(key, PARSER.parseExpression(expression));
    }

    MailHeadersBuilder() {
    }
}

