/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import org.springframework.integration.mail.transformer.AbstractMailMessageTransformer;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.util.Assert;

public class MailToStringTransformer
extends AbstractMailMessageTransformer<String> {
    private String charset = "UTF-8";

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), () -> "unsupported charset '" + charset + "'");
        this.charset = charset;
    }

    @Override
    protected AbstractIntegrationMessageBuilder<String> doTransform(Message mailMessage) throws Exception {
        Object content = mailMessage.getContent();
        if (content instanceof String) {
            return this.getMessageBuilderFactory().withPayload((Object)((String)content));
        }
        if (content instanceof Multipart) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ((Multipart)content).writeTo((OutputStream)outputStream);
            return this.getMessageBuilderFactory().withPayload((Object)new String(outputStream.toByteArray(), this.charset));
        }
        if (content instanceof Part) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ((Part)content).writeTo((OutputStream)outputStream);
            return this.getMessageBuilderFactory().withPayload((Object)new String(outputStream.toByteArray(), this.charset));
        }
        throw new IllegalArgumentException("failed to transform contentType [" + mailMessage.getContentType() + "] to String.");
    }
}

