/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.util.Assert;

final class ExpressionEvaluatingParameterSourceUtils {
    private ExpressionEvaluatingParameterSourceUtils() {
    }

    public static Map<String, Object> convertStaticParameters(Collection<JpaParameter> jpaParameters) {
        Assert.notNull(jpaParameters, (String)"The Collection of jpaParameters must not be null.");
        for (JpaParameter parameter : jpaParameters) {
            Assert.notNull((Object)parameter, (String)"'jpaParameters' must not contain null values.");
        }
        HashMap<String, Object> staticParameters = new HashMap<String, Object>();
        for (JpaParameter parameter : jpaParameters) {
            if (parameter.getValue() == null) continue;
            staticParameters.put(parameter.getName(), parameter.getValue());
        }
        return staticParameters;
    }

    public static class ParameterExpressionEvaluator
    extends AbstractExpressionEvaluator {
        public EvaluationContext getEvaluationContext() {
            return super.getEvaluationContext();
        }

        public @Nullable Object evaluateExpression(Expression expression, Object input) {
            return super.evaluateExpression(expression, input);
        }
    }
}

