/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import java.util.UUID;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.w3c.dom.Element;

public class MBeanExporterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MBEAN_EXPORTER_NAME = "mbeanExporter";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return IntegrationMBeanExporter.class.getName();
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-domain");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"object-name-static-properties");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"managed-components", (String)"componentNamePatterns");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"object-naming-strategy", (String)"namingStrategy");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"server");
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        Object id = super.resolveId(element, definition, parserContext);
        if (MBEAN_EXPORTER_NAME.equals(id)) {
            parserContext.getReaderContext().error("Illegal bean id for <jmx:mbean-export/>: mbeanExporter (clashes with <context:mbean-export/> default).  Please choose another bean id.", (Object)definition);
        }
        if (((String)id).matches(IntegrationMBeanExporter.class.getName() + "#[0-9]+")) {
            id = (String)id + "#" + String.valueOf(UUID.randomUUID());
        }
        return id;
    }
}

