/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.SourceVersion;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.history.MessageHistoryConfigurer;
import org.springframework.integration.monitor.IntegrationJmxAttributeSource;
import org.springframework.integration.monitor.IntegrationMetadataMBeanInfoAssembler;
import org.springframework.integration.monitor.IntegrationMetadataNamingStrategy;
import org.springframework.integration.monitor.ManagedEndpoint;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.LifecycleMessageHandlerMetrics;
import org.springframework.integration.support.management.LifecycleMessageSourceManagement;
import org.springframework.integration.support.management.LifecycleMessageSourceMetrics;
import org.springframework.integration.support.management.LifecycleTrackableMessageHandlerMetrics;
import org.springframework.integration.support.management.LifecycleTrackableMessageSourceManagement;
import org.springframework.integration.support.management.LifecycleTrackableMessageSourceMetrics;
import org.springframework.integration.support.management.MappingMessageRouterManagement;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceManagement;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.integration.support.management.RouterMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.integration.support.management.TrackableRouterMetrics;
import org.springframework.integration.support.utils.PatternMatchUtils;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.UnableToRegisterMBeanException;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MetricType;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

@ManagedResource
public class IntegrationMBeanExporter
extends MBeanExporter
implements ApplicationContextAware,
EmbeddedValueResolverAware,
DestructionAwareBeanPostProcessor {
    private static final Log logger = LogFactory.getLog(IntegrationMBeanExporter.class);
    public static final String DEFAULT_DOMAIN = "org.springframework.integration";
    private final IntegrationJmxAttributeSource attributeSource = new IntegrationJmxAttributeSource();
    private ApplicationContext applicationContext;
    private final Map<Object, AtomicLong> anonymousHandlerCounters = new HashMap<Object, AtomicLong>();
    private final Map<Object, AtomicLong> anonymousSourceCounters = new HashMap<Object, AtomicLong>();
    private final Set<MessageHandlerMetrics> handlers = new HashSet<MessageHandlerMetrics>();
    private final Set<MessageSourceMetrics> sources = new HashSet<MessageSourceMetrics>();
    private final Set<Lifecycle> inboundLifecycleMessageProducers = new HashSet<Lifecycle>();
    private final Set<MessageChannelMetrics> channels = new HashSet<MessageChannelMetrics>();
    private final Map<String, MessageChannelMetrics> allChannelsByName = new HashMap<String, MessageChannelMetrics>();
    private final Map<String, MessageSourceMetrics> allSourcesByName = new HashMap<String, MessageSourceMetrics>();
    private final Map<Object, String> endpointsByMonitor = new HashMap<Object, String>();
    private final Map<Object, ObjectName> objectNames = new HashMap<Object, ObjectName>();
    private final Set<String> endpointNames = new HashSet<String>();
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private final Properties objectNameStaticProperties = new Properties();
    private final Set<Object> runtimeBeans = new HashSet<Object>();
    private final MetadataNamingStrategy defaultNamingStrategy = new IntegrationMetadataNamingStrategy((JmxAttributeSource)this.attributeSource);
    private String domain = "org.springframework.integration";
    private String[] componentNamePatterns = new String[]{"*"};
    private IntegrationManagementConfigurer managementConfigurer;
    private volatile long shutdownDeadline;
    private volatile boolean singletonsInstantiated;

    public IntegrationMBeanExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)this.defaultNamingStrategy);
        this.setAssembler((MBeanInfoAssembler)new IntegrationMetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource));
    }

    public void setObjectNameStaticProperties(Map<String, String> objectNameStaticProperties) {
        this.objectNameStaticProperties.putAll(objectNameStaticProperties);
    }

    public void setDefaultDomain(String domain) {
        this.domain = domain;
        this.defaultNamingStrategy.setDefaultDomain(domain);
    }

    public void setComponentNamePatterns(String[] componentNamePatterns) {
        Assert.notEmpty((Object[])componentNamePatterns, (String)"componentNamePatterns must not be empty");
        this.componentNamePatterns = Arrays.copyOf(componentNamePatterns, componentNamePatterns.length);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext may not be null");
        this.applicationContext = applicationContext;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.attributeSource.setValueResolver(resolver);
    }

    public void afterSingletonsInstantiated() {
        Map messageHandlers = this.applicationContext.getBeansOfType(MessageHandlerMetrics.class);
        for (Map.Entry entry : messageHandlers.entrySet()) {
            String string = (String)entry.getKey();
            MessageHandlerMetrics messageHandlerMetrics = (MessageHandlerMetrics)entry.getValue();
            if (this.handlerInAnonymousWrapper(messageHandlerMetrics) != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Skipping " + string + " because it wraps another handler"));
                continue;
            }
            MessageHandlerMetrics messageHandlerMetrics2 = (MessageHandlerMetrics)this.extractTarget(messageHandlerMetrics);
            this.handlers.add(messageHandlerMetrics2);
        }
        Map messageSources = this.applicationContext.getBeansOfType(MessageSourceMetrics.class);
        for (Map.Entry entry : messageSources.entrySet()) {
            MessageSourceMetrics messageSourceMetrics = (MessageSourceMetrics)this.extractTarget(entry.getValue());
            this.sources.add(messageSourceMetrics);
        }
        Map map = this.applicationContext.getBeansOfType(MessageChannelMetrics.class);
        for (Map.Entry entry : map.entrySet()) {
            MessageChannelMetrics messageChannelMetrics = (MessageChannelMetrics)this.extractTarget(entry.getValue());
            this.channels.add(messageChannelMetrics);
        }
        Map map2 = this.applicationContext.getBeansOfType(MessageProducer.class);
        for (Map.Entry entry : map2.entrySet()) {
            MessageProducer messageProducer = (MessageProducer)entry.getValue();
            if (!(messageProducer instanceof Lifecycle)) continue;
            this.registerProducer(messageProducer);
        }
        super.afterSingletonsInstantiated();
        try {
            Object object;
            this.registerChannels();
            this.registerHandlers();
            this.registerSources();
            this.registerEndpoints();
            if (this.applicationContext.containsBean("messageHistoryConfigurer") && (object = this.applicationContext.getBean("messageHistoryConfigurer")) instanceof MessageHistoryConfigurer) {
                this.registerBeanInstance(object, "messageHistoryConfigurer");
            }
            if (!this.applicationContext.containsBean("integrationManagementConfigurer")) {
                this.managementConfigurer = new IntegrationManagementConfigurer();
                this.managementConfigurer.setDefaultCountsEnabled(Boolean.valueOf(true));
                this.managementConfigurer.setDefaultStatsEnabled(Boolean.valueOf(true));
                this.managementConfigurer.setApplicationContext(this.applicationContext);
                this.managementConfigurer.setBeanName("integrationManagementConfigurer");
                this.managementConfigurer.afterSingletonsInstantiated();
            } else {
                this.managementConfigurer = (IntegrationManagementConfigurer)this.applicationContext.getBean("integrationManagementConfigurer", IntegrationManagementConfigurer.class);
            }
            this.singletonsInstantiated = true;
        }
        catch (RuntimeException runtimeException) {
            this.unregisterBeans();
            throw runtimeException;
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.singletonsInstantiated) {
            try {
                if (bean instanceof MessageChannelMetrics) {
                    MessageChannelMetrics monitor = (MessageChannelMetrics)this.extractTarget(bean);
                    this.channels.add(monitor);
                    this.registerChannel(monitor);
                    this.runtimeBeans.add(bean);
                } else if (bean instanceof MessageProducer && bean instanceof Lifecycle) {
                    this.registerProducer((MessageProducer)bean);
                    this.runtimeBeans.add(bean);
                } else if (bean instanceof AbstractEndpoint) {
                    SourcePollingChannelAdapter pollingChannelAdapter;
                    MessageSource messageSource;
                    if (bean instanceof IntegrationConsumer) {
                        IntegrationConsumer integrationConsumer = (IntegrationConsumer)bean;
                        MessageHandler handler = integrationConsumer.getHandler();
                        if (handler instanceof MessageHandlerMetrics) {
                            MessageHandlerMetrics messageHandlerMetrics = (MessageHandlerMetrics)this.extractTarget(handler);
                            this.registerHandler(messageHandlerMetrics);
                            this.handlers.add(messageHandlerMetrics);
                            this.runtimeBeans.add(messageHandlerMetrics);
                            return bean;
                        }
                    } else if (bean instanceof SourcePollingChannelAdapter && (messageSource = (pollingChannelAdapter = (SourcePollingChannelAdapter)bean).getMessageSource()) instanceof MessageSourceMetrics) {
                        MessageSourceMetrics messageSourceMetrics = (MessageSourceMetrics)this.extractTarget(messageSource);
                        this.registerSource(messageSourceMetrics);
                        this.sources.add(messageSourceMetrics);
                        this.runtimeBeans.add(messageSourceMetrics);
                        return bean;
                    }
                    this.registerEndpoint((AbstractEndpoint)bean);
                    this.runtimeBeans.add(bean);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Could not register an MBean for: " + beanName), (Throwable)e);
            }
        }
        return bean;
    }

    private void registerProducer(MessageProducer messageProducer) {
        Lifecycle target = (Lifecycle)this.extractTarget(messageProducer);
        if (!(target instanceof AbstractMessageProducingHandler)) {
            this.inboundLifecycleMessageProducers.add(target);
        }
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof MessageChannelMetrics || bean instanceof MessageHandlerMetrics || bean instanceof MessageSourceMetrics || bean instanceof MessageProducer && bean instanceof Lifecycle || bean instanceof AbstractEndpoint;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.runtimeBeans.remove(bean)) {
            ObjectName objectName = this.objectNames.remove(bean);
            if (objectName != null) {
                this.doUnregister(objectName);
                if (bean instanceof AbstractEndpoint) {
                    this.endpointNames.remove(((AbstractEndpoint)bean).getComponentName());
                } else {
                    this.endpointsByMonitor.remove(bean);
                    if (bean instanceof MessageChannelMetrics) {
                        this.channels.remove(bean);
                        this.allChannelsByName.remove(((NamedComponent)bean).getComponentName());
                    } else if (bean instanceof MessageHandlerMetrics) {
                        this.handlers.remove(bean);
                        this.endpointNames.remove(((NamedComponent)bean).getComponentName());
                    } else if (bean instanceof MessageSourceMetrics) {
                        this.sources.remove(bean);
                        this.endpointNames.remove(((NamedComponent)bean).getComponentName());
                        String managedName = ((MessageSourceMetrics)bean).getManagedName();
                        this.allSourcesByName.remove(managedName);
                    }
                }
            } else if (bean instanceof MessageProducer && bean instanceof Lifecycle) {
                this.inboundLifecycleMessageProducers.remove(bean);
            }
        }
    }

    private MessageHandler handlerInAnonymousWrapper(Object bean) {
        if (bean != null && bean.getClass().isAnonymousClass()) {
            AtomicReference wrapped = new AtomicReference();
            ReflectionUtils.doWithFields(bean.getClass(), field -> {
                field.setAccessible(true);
                Object handler = field.get(bean);
                if (handler instanceof MessageHandler) {
                    wrapped.set((MessageHandler)handler);
                }
            }, field -> wrapped.get() == null && field.getName().startsWith("val$"));
            return (MessageHandler)wrapped.get();
        }
        return null;
    }

    private ObjectName registerBeanInstance(Object bean, String beanKey) {
        try {
            ObjectName objectName = this.getObjectName(bean, beanKey);
            Object mbeanToExpose = null;
            if (this.isMBean(bean.getClass())) {
                mbeanToExpose = bean;
            } else {
                DynamicMBean adaptedBean = this.adaptMBeanIfPossible(bean);
                if (adaptedBean != null) {
                    mbeanToExpose = adaptedBean;
                }
            }
            if (mbeanToExpose != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Located MBean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]"));
                }
                this.doRegister(mbeanToExpose, objectName);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Located managed bean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]"));
                }
                ModelMBean mbean = this.createAndConfigureMBean(bean, beanKey);
                this.doRegister(mbean, objectName);
            }
            return objectName;
        }
        catch (JMException e) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + bean + "] with key '" + beanKey + "'", (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        for (MessageChannelMetrics messageChannelMetrics : this.channels) {
            logger.info((Object)("Summary on shutdown: " + messageChannelMetrics));
        }
        for (MessageHandlerMetrics messageHandlerMetrics : this.handlers) {
            logger.info((Object)("Summary on shutdown: " + messageHandlerMetrics));
        }
        for (MessageSourceMetrics messageSourceMetrics : this.sources) {
            logger.info((Object)("Summary on shutdown: " + messageSourceMetrics));
        }
    }

    @ManagedOperation
    public void stopActiveComponents(long howLong) {
        if (!this.shuttingDown.compareAndSet(false, true)) {
            logger.error((Object)"Shutdown already in process");
            return;
        }
        this.shutdownDeadline = System.currentTimeMillis() + howLong;
        try {
            logger.debug((Object)"Running shutdown");
            this.doShutdown();
        }
        catch (Exception e) {
            logger.error((Object)"Orderly shutdown failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        try {
            this.orderlyShutdownCapableComponentsBefore();
            this.stopActiveChannels();
            this.stopMessageSources();
            this.stopInboundMessageProducers();
            long timeLeft = this.shutdownDeadline - System.currentTimeMillis();
            if (timeLeft > 0L) {
                try {
                    Thread.sleep(timeLeft);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while waiting for quiesce");
                }
            }
            this.orderlyShutdownCapableComponentsAfter();
        }
        finally {
            this.shuttingDown.set(false);
        }
    }

    @ManagedOperation
    public void stopMessageSources() {
        for (Map.Entry<String, MessageSourceMetrics> entry : this.allSourcesByName.entrySet()) {
            MessageSourceMetrics sourceMetrics = entry.getValue();
            if (sourceMetrics instanceof Lifecycle) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Stopping message source " + sourceMetrics));
                }
                ((Lifecycle)sourceMetrics).stop();
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Message source " + sourceMetrics + " cannot be stopped"));
        }
    }

    @ManagedOperation
    public void stopInboundMessageProducers() {
        for (Lifecycle producer : this.inboundLifecycleMessageProducers) {
            if (producer instanceof OrderlyShutdownCapable) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Stopping message producer " + producer));
            }
            producer.stop();
        }
    }

    @ManagedOperation
    public void stopActiveChannels() {
        for (Map.Entry<String, MessageChannelMetrics> entry : this.allChannelsByName.entrySet()) {
            MessageChannelMetrics metrics = entry.getValue();
            MessageChannel channel = (MessageChannel)metrics;
            if (!(channel instanceof Lifecycle)) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Stopping channel " + channel));
            }
            ((Lifecycle)channel).stop();
        }
    }

    protected final void orderlyShutdownCapableComponentsBefore() {
        logger.debug((Object)"Initiating stop OrderlyShutdownCapable components");
        Map components = this.applicationContext.getBeansOfType(OrderlyShutdownCapable.class);
        for (Map.Entry componentEntry : components.entrySet()) {
            OrderlyShutdownCapable component = (OrderlyShutdownCapable)componentEntry.getValue();
            int n = component.beforeShutdown();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Initiated stop for component " + component + "; it reported " + n + " active messages"));
        }
        logger.debug((Object)"Initiated stop OrderlyShutdownCapable components");
    }

    protected final void orderlyShutdownCapableComponentsAfter() {
        logger.debug((Object)"Finalizing stop OrderlyShutdownCapable components");
        Map components = this.applicationContext.getBeansOfType(OrderlyShutdownCapable.class);
        for (Map.Entry componentEntry : components.entrySet()) {
            OrderlyShutdownCapable component = (OrderlyShutdownCapable)componentEntry.getValue();
            int n = component.afterShutdown();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Finalized stop for component " + component + "; it reported " + n + " active messages"));
        }
        logger.debug((Object)"Finalized stop OrderlyShutdownCapable components");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Count")
    public int getChannelCount() {
        return this.managementConfigurer.getChannelNames().length;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageHandler Count")
    public int getHandlerCount() {
        return this.managementConfigurer.getHandlerNames().length;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageSource Count")
    public int getSourceCount() {
        return this.managementConfigurer.getSourceNames().length;
    }

    @ManagedAttribute
    public String[] getHandlerNames() {
        return this.managementConfigurer.getHandlerNames();
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Active Handler Count")
    public int getActiveHandlerCount() {
        return (int)this.getActiveHandlerCountLong();
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Active Handler Count")
    public long getActiveHandlerCountLong() {
        int count = 0;
        for (MessageHandlerMetrics monitor : this.handlers) {
            count = (int)((long)count + monitor.getActiveCountLong());
        }
        return count;
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Queued Message Count")
    public int getQueuedMessageCount() {
        int count = 0;
        for (MessageChannelMetrics monitor : this.channels) {
            if (!(monitor instanceof QueueChannel)) continue;
            count += ((QueueChannel)monitor).getQueueSize();
        }
        return count;
    }

    @ManagedAttribute
    public String[] getChannelNames() {
        return this.managementConfigurer.getChannelNames();
    }

    public MessageHandlerMetrics getHandlerMetrics(String name) {
        return this.managementConfigurer.getHandlerMetrics(name);
    }

    public Statistics getHandlerDuration(String name) {
        MessageHandlerMetrics handlerMetrics = this.getHandlerMetrics(name);
        return handlerMetrics != null ? handlerMetrics.getDuration() : null;
    }

    @ManagedAttribute
    public String[] getSourceNames() {
        return this.managementConfigurer.getSourceNames();
    }

    public MessageSourceMetrics getSourceMetrics(String name) {
        return this.managementConfigurer.getSourceMetrics(name);
    }

    public int getSourceMessageCount(String name) {
        return (int)this.getSourceMessageCountLong(name);
    }

    public long getSourceMessageCountLong(String name) {
        MessageSourceMetrics sourceMetrics = this.getSourceMetrics(name);
        return sourceMetrics != null ? sourceMetrics.getMessageCountLong() : -1L;
    }

    public MessageChannelMetrics getChannelMetrics(String name) {
        return this.managementConfigurer.getChannelMetrics(name);
    }

    public int getChannelSendCount(String name) {
        return (int)this.getChannelSendCountLong(name);
    }

    public long getChannelSendCountLong(String name) {
        MessageChannelMetrics channelMetrics = this.getChannelMetrics(name);
        return channelMetrics != null ? channelMetrics.getSendCountLong() : -1L;
    }

    public int getChannelSendErrorCount(String name) {
        return (int)this.getChannelSendErrorCountLong(name);
    }

    public long getChannelSendErrorCountLong(String name) {
        MessageChannelMetrics channelMetrics = this.getChannelMetrics(name);
        return channelMetrics != null ? channelMetrics.getSendErrorCountLong() : -1L;
    }

    public int getChannelReceiveCount(String name) {
        return (int)this.getChannelReceiveCountLong(name);
    }

    public long getChannelReceiveCountLong(String name) {
        MessageChannelMetrics channelMetrics = this.getChannelMetrics(name);
        if (channelMetrics instanceof PollableChannelManagement) {
            return ((PollableChannelManagement)channelMetrics).getReceiveCountLong();
        }
        return -1L;
    }

    @ManagedOperation
    public Statistics getChannelSendRate(String name) {
        MessageChannelMetrics channelMetrics = this.getChannelMetrics(name);
        return channelMetrics != null ? channelMetrics.getSendRate() : null;
    }

    public Statistics getChannelErrorRate(String name) {
        MessageChannelMetrics channelMetrics = this.getChannelMetrics(name);
        return channelMetrics != null ? channelMetrics.getErrorRate() : null;
    }

    private void registerChannels() {
        this.channels.forEach(this::registerChannel);
    }

    private void registerChannel(MessageChannelMetrics monitor) {
        String name = ((NamedComponent)monitor).getComponentName();
        this.allChannelsByName.put(name, monitor);
        if (this.matches(this.componentNamePatterns, name)) {
            String beanKey = this.getChannelBeanKey(name);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registering MessageChannel " + name));
            }
            ObjectName objectName = this.registerBeanNameOrInstance(monitor, beanKey);
            this.objectNames.put(monitor, objectName);
        }
    }

    private void registerHandlers() {
        this.handlers.forEach(this::registerHandler);
    }

    private void registerHandler(MessageHandlerMetrics handler) {
        MessageHandlerMetrics monitor = this.enhanceHandlerMonitor(handler);
        String name = monitor.getManagedName();
        if (this.matches(this.componentNamePatterns, name)) {
            String beanKey = this.getHandlerBeanKey(monitor);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registering MessageHandler " + name));
            }
            ObjectName objectName = this.registerBeanNameOrInstance(monitor, beanKey);
            this.objectNames.put(handler, objectName);
        }
    }

    private void registerSources() {
        this.sources.forEach(this::registerSource);
    }

    private void registerSource(MessageSourceMetrics source) {
        MessageSourceMetrics monitor = this.enhanceSourceMonitor(source);
        String name = monitor.getManagedName();
        this.allSourcesByName.put(name, monitor);
        if (this.matches(this.componentNamePatterns, name)) {
            String beanKey = this.getSourceBeanKey(monitor);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registering MessageSource " + name));
            }
            ObjectName objectName = this.registerBeanNameOrInstance(monitor, beanKey);
            this.objectNames.put(source, objectName);
        }
    }

    private void registerEndpoints() {
        String[] names;
        for (String name : names = this.applicationContext.getBeanNamesForType(AbstractEndpoint.class)) {
            if (this.endpointsByMonitor.values().contains(name)) continue;
            AbstractEndpoint endpoint = (AbstractEndpoint)this.applicationContext.getBean(name, AbstractEndpoint.class);
            this.registerEndpoint(endpoint);
        }
    }

    private void registerEndpoint(AbstractEndpoint endpoint) {
        String source;
        String name = endpoint.getComponentName();
        if (name.startsWith("_org.springframework.integration")) {
            name = this.getInternalComponentName(name);
            source = "internal";
        } else {
            source = "endpoint";
        }
        if (this.matches(this.componentNamePatterns, name)) {
            if (this.endpointNames.contains(name)) {
                int count = 0;
                String unique = name + "#" + count;
                while (this.endpointNames.contains(unique)) {
                    unique = name + "#" + ++count;
                }
                name = unique;
            }
            this.endpointNames.add(name);
            String beanKey = this.getEndpointBeanKey(endpoint, name, source);
            ObjectName objectName = this.registerBeanInstance(new ManagedEndpoint(endpoint), beanKey);
            this.objectNames.put(endpoint, objectName);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered endpoint without MessageSource: " + objectName));
            }
        }
    }

    private boolean matches(String[] patterns, String name) {
        Boolean match = PatternMatchUtils.smartMatch((String)name, (String[])patterns);
        return match == null ? false : match;
    }

    private Object extractTarget(Object bean) {
        if (!(bean instanceof Advised)) {
            return bean;
        }
        Advised advised = (Advised)bean;
        if (advised.getTargetSource() == null) {
            return null;
        }
        try {
            return this.extractTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            logger.error((Object)"Could not extract target", (Throwable)e);
            return null;
        }
    }

    private String getChannelBeanKey(String channel) {
        String extra = "";
        if (channel.startsWith(DEFAULT_DOMAIN)) {
            extra = ",source=anonymous";
        }
        return String.format(this.domain + ":type=MessageChannel,name=%s%s" + this.getStaticNames(), this.quoteIfNecessary(channel), extra);
    }

    private String getHandlerBeanKey(MessageHandlerMetrics handler) {
        return String.format(this.domain + ":type=MessageHandler,name=%s,bean=%s" + this.getStaticNames(), this.quoteIfNecessary(handler.getManagedName()), this.quoteIfNecessary(handler.getManagedType()));
    }

    private String getSourceBeanKey(MessageSourceMetrics source) {
        return String.format(this.domain + ":type=MessageSource,name=%s,bean=%s" + this.getStaticNames(), this.quoteIfNecessary(source.getManagedName()), this.quoteIfNecessary(source.getManagedType()));
    }

    private String getEndpointBeanKey(AbstractEndpoint endpoint, String name, String source) {
        return String.format(this.domain + ":type=ManagedEndpoint,name=%s,bean=%s" + this.getStaticNames(), this.quoteIfNecessary(name), source);
    }

    private String quoteIfNecessary(String name) {
        return SourceVersion.isName(name) ? name : ObjectName.quote(name);
    }

    private String getStaticNames() {
        if (this.objectNameStaticProperties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.objectNameStaticProperties.entrySet()) {
            builder.append("," + entry.getKey() + "=" + entry.getValue());
        }
        return builder.toString();
    }

    private MessageHandlerMetrics enhanceHandlerMonitor(MessageHandlerMetrics monitor) {
        MessageChannel inputChannel;
        Object result = monitor;
        if (monitor.getManagedName() != null && monitor.getManagedType() != null) {
            return monitor;
        }
        String[] names = this.applicationContext.getBeanNamesForType(IntegrationConsumer.class);
        String name = null;
        String endpointName = null;
        String source = "endpoint";
        IntegrationConsumer endpoint = null;
        for (String beanName : names) {
            endpoint = (IntegrationConsumer)this.applicationContext.getBean(beanName, IntegrationConsumer.class);
            try {
                MessageHandler handler = endpoint.getHandler();
                if (handler != monitor && this.extractTarget(this.handlerInAnonymousWrapper(handler)) != monitor) continue;
                name = beanName;
                endpointName = beanName;
                break;
            }
            catch (Exception e) {
                logger.trace((Object)("Could not get handler from bean = " + beanName));
                endpoint = null;
            }
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = this.getInternalComponentName(name);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN) && (inputChannel = endpoint.getInputChannel()) != null) {
            if (!this.anonymousHandlerCounters.containsKey(inputChannel)) {
                this.anonymousHandlerCounters.put(inputChannel, new AtomicLong());
            }
            AtomicLong count = this.anonymousHandlerCounters.get(inputChannel);
            long total = count.incrementAndGet();
            String suffix = "";
            if (total > 1L) {
                suffix = "#" + total;
            }
            name = inputChannel + suffix;
            source = "anonymous";
        }
        if (endpoint instanceof Lifecycle) {
            result = monitor instanceof MappingMessageRouterManagement ? (monitor instanceof TrackableComponent ? new TrackableRouterMetrics((Lifecycle)endpoint, (MappingMessageRouterManagement)monitor) : new RouterMetrics((Lifecycle)endpoint, (MappingMessageRouterManagement)monitor)) : (monitor instanceof TrackableComponent ? new LifecycleTrackableMessageHandlerMetrics((Lifecycle)endpoint, monitor) : new LifecycleMessageHandlerMetrics((Lifecycle)endpoint, monitor));
        }
        if (name == null) {
            if (monitor instanceof NamedComponent) {
                name = ((NamedComponent)monitor).getComponentName();
            }
            if (name == null) {
                name = monitor.toString();
            }
            source = "handler";
        }
        if (endpointName != null) {
            this.endpointsByMonitor.put(monitor, endpointName);
        }
        result.setManagedType(source);
        result.setManagedName(name);
        return result;
    }

    private String getInternalComponentName(String name) {
        return name.substring("_org.springframework.integration".length() + 1);
    }

    private MessageSourceMetrics enhanceSourceMonitor(MessageSourceMetrics monitor) {
        Object result = monitor;
        if (monitor.getManagedName() != null) {
            return monitor;
        }
        String[] names = this.applicationContext.getBeanNamesForType(AbstractEndpoint.class);
        String name = null;
        String endpointName = null;
        String source = "endpoint";
        Object endpoint = null;
        for (String beanName : names) {
            endpoint = this.applicationContext.getBean(beanName);
            Object field = null;
            if (monitor instanceof MessagingGatewaySupport && endpoint == monitor) {
                field = monitor;
            } else {
                try {
                    field = this.extractTarget(IntegrationMBeanExporter.getField(endpoint, "source"));
                }
                catch (Exception e) {
                    logger.trace((Object)("Could not get source from bean = " + beanName));
                    endpoint = null;
                }
            }
            if (field != monitor) continue;
            name = beanName;
            endpointName = beanName;
            break;
        }
        if (endpointName == null) {
            endpoint = null;
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = this.getInternalComponentName(name);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN)) {
            TargetSource targetSource;
            Object target = endpoint;
            if (endpoint instanceof Advised && (targetSource = ((Advised)endpoint).getTargetSource()) != null) {
                try {
                    target = targetSource.getTarget();
                }
                catch (Exception e) {
                    logger.error((Object)("Could not get handler from bean = " + name));
                }
            }
            MessageChannel outputChannel = null;
            outputChannel = target instanceof MessagingGatewaySupport ? ((MessagingGatewaySupport)target).getRequestChannel() : ((SourcePollingChannelAdapter)target).getOutputChannel();
            if (outputChannel != null) {
                if (!this.anonymousSourceCounters.containsKey(outputChannel)) {
                    this.anonymousSourceCounters.put(outputChannel, new AtomicLong());
                }
                AtomicLong count = this.anonymousSourceCounters.get(outputChannel);
                long total = count.incrementAndGet();
                String suffix = "";
                if (total > 1L) {
                    suffix = "#" + total;
                }
                name = outputChannel + suffix;
                source = "anonymous";
            }
        }
        if (endpoint instanceof Lifecycle) {
            result = endpoint instanceof TrackableComponent ? (monitor instanceof MessageSourceManagement ? new LifecycleTrackableMessageSourceManagement((Lifecycle)endpoint, (MessageSourceManagement)monitor) : new LifecycleTrackableMessageSourceMetrics((Lifecycle)endpoint, monitor)) : (monitor instanceof MessageSourceManagement ? new LifecycleMessageSourceManagement((Lifecycle)endpoint, (MessageSourceManagement)monitor) : new LifecycleMessageSourceMetrics((Lifecycle)endpoint, monitor));
        }
        if (name == null) {
            name = monitor.toString();
            source = "source";
        }
        if (endpointName != null) {
            this.endpointsByMonitor.put(monitor, endpointName);
        }
        monitor.setManagedType(source);
        monitor.setManagedName(name);
        return result;
    }

    private static Object getField(Object target, String name) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }
}

