/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.util;

import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public abstract class JmsAdapterUtils {
    public static final String AUTO_ACKNOWLEDGE_STRING = "auto";
    public static final String DUPS_OK_ACKNOWLEDGE_STRING = "dups-ok";
    public static final String CLIENT_ACKNOWLEDGE_STRING = "client";
    public static final String SESSION_TRANSACTED_STRING = "transacted";
    public static final int SESSION_TRANSACTED = 0;
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;

    public static @Nullable Integer parseAcknowledgeMode(@Nullable String acknowledge) {
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if (SESSION_TRANSACTED_STRING.equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if (DUPS_OK_ACKNOWLEDGE_STRING.equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if (CLIENT_ACKNOWLEDGE_STRING.equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!AUTO_ACKNOWLEDGE_STRING.equals(acknowledge)) {
                throw new IllegalStateException("Invalid JMS 'acknowledge' setting: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.");
            }
            return acknowledgeMode;
        }
        return null;
    }
}

