/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.JmsSendingMessageHandler;
import org.springframework.integration.jms.config.JmsParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsSendingMessageHandler.class);
        String jmsTemplate = element.getAttribute("jms-template");
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute("destination-name");
        String destinationExpression = element.getAttribute("destination-expression");
        boolean hasJmsTemplate = StringUtils.hasText((String)jmsTemplate);
        boolean hasDestinationRef = StringUtils.hasText((String)destination);
        boolean hasDestinationName = StringUtils.hasText((String)destinationName);
        boolean hasDestinationExpression = StringUtils.hasText((String)destinationExpression);
        if (hasJmsTemplate) {
            JmsParserUtils.verifyNoJmsTemplateAttributes(element, parserContext);
            builder.addConstructorArgReference(jmsTemplate);
        } else {
            builder.addConstructorArgValue((Object)JmsParserUtils.parseJmsTemplateBeanDefinition(element, parserContext));
        }
        if (hasDestinationRef || hasDestinationName || hasDestinationExpression) {
            if (!(hasDestinationRef ^ hasDestinationName ^ hasDestinationExpression)) {
                parserContext.getReaderContext().error("The 'destination', 'destination-name', and 'destination-expression' attributes are mutually exclusive.", parserContext.extractSource((Object)element));
            }
            if (hasDestinationRef) {
                builder.addPropertyReference("destination", destination);
            } else if (hasDestinationName) {
                builder.addPropertyValue("destinationName", (Object)destinationName);
            } else {
                BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)destinationExpression);
                builder.addPropertyValue("destinationExpression", (Object)expressionBuilder.getBeanDefinition());
            }
        } else if (!hasJmsTemplate) {
            parserContext.getReaderContext().error("either a 'jms-template' or one of 'destination', 'destination-name', or 'destination-expression' attributes must be provided", parserContext.extractSource((Object)element));
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"header-mapper");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delivery-mode-expression", (String)"deliveryModeExpressionString");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live-expression", (String)"timeToLiveExpressionString");
        return builder.getBeanDefinition();
    }
}

