/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.util.JmsAdapterUtils;
import org.springframework.integration.support.management.metrics.MetricsCaptor;
import org.springframework.integration.support.management.observation.MessageReceiverObservationConvention;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class JmsMessageDrivenEndpoint
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer listenerContainer;
    private final boolean externalContainer;
    private final ChannelPublishingJmsMessageListener listener;
    private String sessionAcknowledgeMode;
    private boolean shutdownContainerOnStop = true;
    private volatile boolean hasStopped;

    public JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this(listenerContainer, listener, true);
    }

    private JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener, boolean externalContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listener container must not be null");
        Assert.notNull((Object)listener, (String)"listener must not be null");
        Assert.isNull((Object)listenerContainer.getMessageListener(), (String)"The listenerContainer provided to a JMS Inbound Endpoint must not have a MessageListener configured since the endpoint configures its own listener implementation.");
        listenerContainer.setMessageListener((Object)listener);
        this.listener = listener;
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setAutoStartup(false);
        this.setPhase(0x3FFFFFFF);
        this.externalContainer = externalContainer;
    }

    public void setSessionAcknowledgeMode(String sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        super.setOutputChannel(outputChannel);
        this.listener.setRequestChannel(outputChannel);
    }

    public void setOutputChannelName(String outputChannelName) {
        super.setOutputChannelName(outputChannelName);
        this.listener.setRequestChannelName(outputChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        super.setErrorChannel(errorChannel);
        this.listener.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannelName) {
        super.setErrorChannelName(errorChannelName);
        this.listener.setErrorChannelName(errorChannelName);
    }

    public void setSendTimeout(long sendTimeout) {
        super.setSendTimeout(sendTimeout);
        this.listener.setRequestTimeout(sendTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        super.setShouldTrack(shouldTrack);
        this.listener.setShouldTrack(shouldTrack);
    }

    public void setShutdownContainerOnStop(boolean shutdownContainerOnStop) {
        this.shutdownContainerOnStop = shutdownContainerOnStop;
    }

    public ChannelPublishingJmsMessageListener getListener() {
        return this.listener;
    }

    public void registerMetricsCaptor(MetricsCaptor captor) {
        super.registerMetricsCaptor(captor);
        this.listener.setMetricsCaptor(captor);
    }

    public void registerObservationRegistry(ObservationRegistry observationRegistry) {
        super.registerObservationRegistry(observationRegistry);
        this.listener.setObservationRegistry(observationRegistry);
    }

    public void setObservationConvention(MessageReceiverObservationConvention observationConvention) {
        super.setObservationConvention(observationConvention);
        this.listener.setReceiverObservationConvention(observationConvention);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.listener.setBeanFactory((BeanFactory)applicationContext);
    }

    public String getComponentType() {
        return "jms:message-driven-channel-adapter";
    }

    public void afterSingletonsInstantiated() {
    }

    protected void onInit() {
        Integer acknowledgeMode;
        String sessionAckMode;
        super.onInit();
        this.listener.afterPropertiesSet();
        if (!this.listenerContainer.isActive()) {
            this.listenerContainer.afterPropertiesSet();
        }
        if ((sessionAckMode = this.sessionAcknowledgeMode) == null && !this.externalContainer && DefaultMessageListenerContainer.class.isAssignableFrom(this.listenerContainer.getClass())) {
            sessionAckMode = "transacted";
        }
        if ((acknowledgeMode = JmsAdapterUtils.parseAcknowledgeMode(sessionAckMode)) != null) {
            if (0 == acknowledgeMode) {
                this.listenerContainer.setSessionTransacted(true);
            } else {
                this.listenerContainer.setSessionAcknowledgeMode(acknowledgeMode.intValue());
            }
        }
        this.listener.setComponentName(this.getComponentName());
    }

    protected void doStart() {
        this.listener.start();
        if (!this.listenerContainer.isRunning()) {
            if (this.hasStopped) {
                this.listenerContainer.initialize();
                this.hasStopped = false;
            }
            this.listenerContainer.start();
        }
    }

    protected void doStop() {
        this.listenerContainer.stop();
        if (this.shutdownContainerOnStop) {
            this.hasStopped = true;
            this.listenerContainer.shutdown();
        }
        this.listener.stop();
    }

    public void destroy() {
        super.destroy();
        this.listenerContainer.destroy();
    }

    public int beforeShutdown() {
        this.stop();
        return 0;
    }

    public int afterShutdown() {
        return 0;
    }
}

