/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.ConnectionFactory;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class DynamicJmsTemplate
extends JmsTemplate {
    private static final long NO_CACHING_RECEIVE_TIMEOUT = 1000L;
    private boolean receiveTimeoutExplicitlySet;

    public void setReceiveTimeout(long receiveTimeout) {
        super.setReceiveTimeout(receiveTimeout);
        this.receiveTimeoutExplicitlySet = true;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        super.setConnectionFactory(connectionFactory);
        if (!this.receiveTimeoutExplicitlySet) {
            if (connectionFactory instanceof CachingConnectionFactory && ((CachingConnectionFactory)connectionFactory).isCacheConsumers()) {
                super.setReceiveTimeout(-1L);
            } else {
                super.setReceiveTimeout(1000L);
            }
        }
    }

    public int getPriority() {
        Integer priority = DynamicJmsTemplateProperties.getPriority();
        if (priority == null) {
            return super.getPriority();
        }
        Assert.isTrue((priority >= 0 && priority <= 9 ? 1 : 0) != 0, (String)"JMS priority must be in the range of 0-9");
        return priority;
    }

    public long getReceiveTimeout() {
        Long receiveTimeout = DynamicJmsTemplateProperties.getReceiveTimeout();
        return receiveTimeout != null ? receiveTimeout.longValue() : super.getReceiveTimeout();
    }

    public int getDeliveryMode() {
        Integer deliveryMode = DynamicJmsTemplateProperties.getDeliveryMode();
        return deliveryMode != null ? deliveryMode.intValue() : super.getDeliveryMode();
    }

    public long getTimeToLive() {
        Long timeToLive = DynamicJmsTemplateProperties.getTimeToLive();
        return timeToLive != null ? timeToLive.longValue() : super.getTimeToLive();
    }
}

