/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.dsl.MessageChannelSpec;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.config.JmsChannelFactoryBean;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsPollableMessageChannelSpec<S extends JmsPollableMessageChannelSpec<S>>
extends MessageChannelSpec<S, AbstractJmsChannel> {
    protected final JmsChannelFactoryBean jmsChannelFactoryBean;

    JmsPollableMessageChannelSpec(ConnectionFactory connectionFactory) {
        this(new JmsChannelFactoryBean(false), connectionFactory);
    }

    JmsPollableMessageChannelSpec(JmsChannelFactoryBean jmsChannelFactoryBean, ConnectionFactory connectionFactory) {
        this.jmsChannelFactoryBean = jmsChannelFactoryBean;
        this.jmsChannelFactoryBean.setConnectionFactory(connectionFactory);
        this.jmsChannelFactoryBean.setSingleton(false);
        this.jmsChannelFactoryBean.setBeanFactory((BeanFactory)new DefaultListableBeanFactory());
    }

    protected S id(String id) {
        this.jmsChannelFactoryBean.setBeanName(id);
        return (S)((Object)((JmsPollableMessageChannelSpec)super.id(id)));
    }

    public S destination(String destination) {
        this.jmsChannelFactoryBean.setDestinationName(destination);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S destinationResolver(DestinationResolver destinationResolver) {
        this.jmsChannelFactoryBean.setDestinationResolver(destinationResolver);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S destination(Destination destination) {
        this.jmsChannelFactoryBean.setDestination(destination);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S messageSelector(String messageSelector) {
        this.jmsChannelFactoryBean.setMessageSelector(messageSelector);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S jmsMessageConverter(MessageConverter messageConverter) {
        this.jmsChannelFactoryBean.setMessageConverter(messageConverter);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S deliveryPersistent(boolean deliveryPersistent) {
        this.jmsChannelFactoryBean.setDeliveryPersistent(deliveryPersistent);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S explicitQosEnabled(boolean explicitQosEnabled) {
        this.jmsChannelFactoryBean.setExplicitQosEnabled(explicitQosEnabled);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S messageIdEnabled(boolean messageIdEnabled) {
        this.jmsChannelFactoryBean.setMessageIdEnabled(messageIdEnabled);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S messageTimestampEnabled(boolean messageTimestampEnabled) {
        this.jmsChannelFactoryBean.setMessageTimestampEnabled(messageTimestampEnabled);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S priority(int priority) {
        this.jmsChannelFactoryBean.setPriority(priority);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S timeToLive(long timeToLive) {
        this.jmsChannelFactoryBean.setTimeToLive(timeToLive);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S receiveTimeout(long receiveTimeout) {
        this.jmsChannelFactoryBean.setReceiveTimeout(receiveTimeout);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S sessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.jmsChannelFactoryBean.setSessionAcknowledgeMode(sessionAcknowledgeMode);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    public S sessionTransacted(boolean sessionTransacted) {
        this.jmsChannelFactoryBean.setSessionTransacted(sessionTransacted);
        return (S)((Object)((JmsPollableMessageChannelSpec)this._this()));
    }

    protected AbstractJmsChannel doGet() {
        try {
            this.channel = (AbstractMessageChannel)this.jmsChannelFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Cannot create the JMS MessageChannel", (Throwable)e);
        }
        return (AbstractJmsChannel)super.doGet();
    }
}

