/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.util;

import org.springframework.util.StringUtils;

public abstract class JmsAdapterUtils {
    public static final int SESSION_TRANSACTED = 0;
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;

    public static Integer parseAcknowledgeMode(String acknowledge) {
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if ("transacted".equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if ("dups-ok".equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if ("client".equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!"auto".equals(acknowledge)) {
                throw new IllegalStateException("Invalid JMS 'acknowledge' setting: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.");
            }
            return acknowledgeMode;
        }
        return null;
    }
}

