/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.integration.jdbc.store.channel.ChannelMessageStorePreparedStatementSetter;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class JsonChannelMessageStorePreparedStatementSetter
extends ChannelMessageStorePreparedStatementSetter {
    private final JsonObjectMapper<?, ?> jsonObjectMapper;

    public JsonChannelMessageStorePreparedStatementSetter() {
        this(JsonObjectMapperProvider.newMessagingAwareInstance((String[])new String[0]));
    }

    public JsonChannelMessageStorePreparedStatementSetter(JsonObjectMapper<?, ?> jsonObjectMapper) {
        Assert.notNull(jsonObjectMapper, (String)"'jsonObjectMapper' must not be null");
        this.jsonObjectMapper = jsonObjectMapper;
    }

    @Override
    public void setValues(PreparedStatement preparedStatement, Message<?> requestMessage, Object groupId, String region, boolean priorityEnabled) throws SQLException {
        super.setValues(preparedStatement, requestMessage, groupId, region, priorityEnabled);
        try {
            String json = this.jsonObjectMapper.toJson(requestMessage);
            String dbProduct = preparedStatement.getConnection().getMetaData().getDatabaseProductName();
            if ("PostgreSQL".equalsIgnoreCase(dbProduct)) {
                preparedStatement.setObject(6, (Object)json, 1111);
            } else {
                preparedStatement.setString(6, json);
            }
        }
        catch (IOException ex) {
            throw new SQLException("Failed to serialize message to JSON: " + String.valueOf(requestMessage), ex);
        }
    }
}

