/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.outbound;

import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.MessagePreparedStatementSetter;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.inbound.JdbcPollingChannelAdapter;
import org.springframework.integration.jdbc.outbound.JdbcMessageHandler;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final @Nullable JdbcMessageHandler handler;
    private final @Nullable JdbcPollingChannelAdapter poller;
    private SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private boolean sqlParameterSourceFactorySet;
    private boolean keysGenerated;
    private @Nullable Integer maxRows;

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, null);
    }

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery, String selectQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, selectQuery);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery) {
        this(jdbcOperations, updateQuery, null);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery, @Nullable String selectQuery) {
        Assert.notNull((Object)jdbcOperations, (String)"'jdbcOperations' must not be null.");
        if (!StringUtils.hasText((String)updateQuery) && !StringUtils.hasText((String)selectQuery)) {
            throw new IllegalArgumentException("The 'updateQuery' and the 'selectQuery' must not both be null or empty.");
        }
        if (StringUtils.hasText((String)selectQuery)) {
            this.poller = new JdbcPollingChannelAdapter(jdbcOperations, selectQuery);
            this.poller.setMaxRows(1);
        } else {
            this.poller = null;
        }
        this.handler = StringUtils.hasText((String)updateQuery) ? new JdbcMessageHandler(jdbcOperations, updateQuery) : null;
    }

    public void setMaxRows(Integer maxRows) {
        Assert.notNull((Object)maxRows, (String)"'maxRows' must not be null.");
        this.maxRows = maxRows;
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setRequestSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        Assert.notNull((Object)((Object)this.handler), (String)"'handler' cannot be null");
        this.handler.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    public void setRequestPreparedStatementSetter(MessagePreparedStatementSetter requestPreparedStatementSetter) {
        Assert.notNull((Object)((Object)this.handler), (String)"'handler' cannot be null");
        this.handler.setPreparedStatementSetter(requestPreparedStatementSetter);
    }

    public void setReplySqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
        this.sqlParameterSourceFactorySet = true;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        Assert.notNull((Object)((Object)this.poller), (String)"'poller' must not be null");
        this.poller.setRowMapper(rowMapper);
    }

    public String getComponentType() {
        return "jdbc:outbound-gateway";
    }

    protected void doInit() {
        if (this.maxRows != null) {
            Assert.notNull((Object)((Object)this.poller), (String)"'poller' must not be null when 'maxRows' is not null");
            this.poller.setMaxRows(this.maxRows);
        }
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.handler != null) {
            this.handler.setBeanFactory(beanFactory);
            this.handler.afterPropertiesSet();
        }
        if (!this.sqlParameterSourceFactorySet) {
            ((ExpressionEvaluatingSqlParameterSourceFactory)this.sqlParameterSourceFactory).setBeanFactory(beanFactory);
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        List<Object> list = Collections.emptyList();
        if (this.handler != null) {
            list = this.handler.executeUpdateQuery(requestMessage, this.keysGenerated);
        }
        if (this.poller != null) {
            SqlParameterSource sqlQueryParameterSource = this.sqlParameterSourceFactory.createParameterSource(requestMessage);
            if (this.keysGenerated && !list.isEmpty()) {
                sqlQueryParameterSource = list.size() == 1 ? this.sqlParameterSourceFactory.createParameterSource(list.get(0)) : this.sqlParameterSourceFactory.createParameterSource(list);
            }
            list = this.poller.doPoll(sqlQueryParameterSource);
        }
        Object payload = list;
        if (list.size() == 1 && (this.maxRows == null || this.maxRows == 1)) {
            payload = list.get(0);
        }
        return payload;
    }
}

