/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.lock;

import java.time.Duration;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.integration.jdbc.lock.LockRepository;
import org.springframework.integration.support.locks.DistributedLock;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.integration.support.locks.RenewableLockRegistry;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.TransactionTimedOutException;
import org.springframework.util.Assert;

public class JdbcLockRegistry
implements ExpirableLockRegistry<DistributedLock>,
RenewableLockRegistry<DistributedLock> {
    private static final int DEFAULT_IDLE = 100;
    private static final int DEFAULT_CAPACITY = 100000;
    private final Lock lock = new ReentrantLock();
    private final Map<String, JdbcLock> locks = new LinkedHashMap<String, JdbcLock>(16, 0.75f, true){
        private static final long serialVersionUID = -8345579941944883141L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, JdbcLock> eldest) {
            return this.size() > JdbcLockRegistry.this.cacheCapacity;
        }
    };
    private final LockRepository client;
    private Duration idleBetweenTries = Duration.ofMillis(100L);
    private int cacheCapacity = 100000;
    public static final Duration DEFAULT_TTL = Duration.ofSeconds(10L);
    private final Duration ttl;

    public JdbcLockRegistry(LockRepository client) {
        this.client = client;
        this.ttl = DEFAULT_TTL;
    }

    public JdbcLockRegistry(LockRepository client, Duration expireAfter) {
        this.client = client;
        this.ttl = expireAfter;
    }

    public void setIdleBetweenTries(Duration idleBetweenTries) {
        Assert.notNull((Object)idleBetweenTries, (String)"'idleBetweenTries' must not be null");
        this.idleBetweenTries = idleBetweenTries;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = this.pathFor((String)lockKey);
        this.lock.lock();
        try {
            DistributedLock distributedLock = this.locks.computeIfAbsent(path, key -> new JdbcLock(this.client, this.idleBetweenTries, (String)key));
            return distributedLock;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String pathFor(String input) {
        return UUIDConverter.getUUID((Object)input).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.locks.entrySet().removeIf(entry -> {
                JdbcLock lock = (JdbcLock)entry.getValue();
                return now - lock.getLastUsed() > age && !lock.isAcquiredInThisProcess();
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public void renewLock(Object lockKey) {
        this.renewLock(lockKey, this.ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLock(Object lockKey, Duration customTtl) {
        JdbcLock jdbcLock;
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = this.pathFor((String)lockKey);
        this.lock.lock();
        try {
            jdbcLock = this.locks.get(path);
        }
        finally {
            this.lock.unlock();
        }
        if (jdbcLock == null) {
            throw new IllegalStateException("Could not found mutex at " + path);
        }
        if (!jdbcLock.renew(customTtl)) {
            throw new IllegalStateException("Could not renew mutex at " + path);
        }
    }

    private static Duration convertToDuration(long time, TimeUnit timeUnit) {
        long timeInMilliseconds = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        return Duration.ofMillis(timeInMilliseconds);
    }

    private final class JdbcLock
    implements DistributedLock {
        private final LockRepository mutex;
        private final Duration idleBetweenTries;
        private final String path;
        private volatile long lastUsed = System.currentTimeMillis();
        private final ReentrantLock delegate = new ReentrantLock();

        JdbcLock(LockRepository client, Duration idleBetweenTries, String path) {
            this.mutex = client;
            this.idleBetweenTries = idleBetweenTries;
            this.path = path;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void lock() {
            this.lock(JdbcLockRegistry.this.ttl);
        }

        public void lock(Duration ttl) {
            this.delegate.lock();
            while (true) {
                try {
                    while (!this.doLock(ttl)) {
                        Thread.sleep(this.idleBetweenTries.toMillis());
                    }
                }
                catch (TransientDataAccessException | TransactionSystemException | TransactionTimedOutException throwable) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock mutex at " + this.path, (Throwable)e);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
            while (true) {
                try {
                    while (!this.doLock(JdbcLockRegistry.this.ttl)) {
                        Thread.sleep(this.idleBetweenTries.toMillis());
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (TransientDataAccessException | TransactionSystemException | TransactionTimedOutException throwable) {
                    continue;
                }
                catch (InterruptedException ie) {
                    this.delegate.unlock();
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.tryLock(Duration.of(time, unit.toChronoUnit()), JdbcLockRegistry.this.ttl);
        }

        public boolean tryLock(Duration waitTime, Duration ttl) throws InterruptedException {
            long now = System.currentTimeMillis();
            if (!this.delegate.tryLock(waitTime.toMillis(), TimeUnit.MILLISECONDS)) {
                return false;
            }
            long expire = now + waitTime.toMillis();
            while (true) {
                try {
                    boolean acquired;
                    while (!(acquired = this.doLock(ttl)) && System.currentTimeMillis() < expire) {
                        Thread.sleep(this.idleBetweenTries.toMillis());
                    }
                    if (!acquired) {
                        this.delegate.unlock();
                    }
                    return acquired;
                }
                catch (TransientDataAccessException | TransactionSystemException | TransactionTimedOutException throwable) {
                    continue;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private boolean doLock(Duration ttl) {
            boolean acquired = this.mutex.acquire(this.path, ttl);
            if (acquired) {
                this.lastUsed = System.currentTimeMillis();
            }
            return acquired;
        }

        public void unlock() {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("The current thread doesn't own mutex at " + this.path);
            }
            if (this.delegate.getHoldCount() > 1) {
                this.delegate.unlock();
                return;
            }
            while (true) {
                block10: {
                    if (!this.mutex.delete(this.path)) break block10;
                    this.delegate.unlock();
                    return;
                }
                try {
                    try {
                        throw new ConcurrentModificationException("Lock was released in the store due to expiration. The integrity of data protected by this lock may have been compromised.");
                    }
                    catch (TransientDataAccessException | TransactionSystemException | TransactionTimedOutException throwable) {
                        continue;
                    }
                    catch (ConcurrentModificationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new DataAccessResourceFailureException("Failed to release mutex at " + this.path, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    this.delegate.unlock();
                    throw throwable;
                }
                break;
            }
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public boolean isAcquiredInThisProcess() {
            return this.delegate.isLocked();
        }

        public boolean renew() {
            return this.renew(JdbcLockRegistry.this.ttl);
        }

        /*
         * Loose catch block
         */
        public boolean renew(Duration ttl) {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("The current thread doesn't own mutex at " + this.path);
            }
            while (true) {
                try {
                    boolean renewed = this.mutex.renew(this.path, ttl);
                    if (renewed) {
                        this.lastUsed = System.currentTimeMillis();
                    }
                    return renewed;
                }
                catch (TransientDataAccessException | TransactionSystemException | TransactionTimedOutException renewed) {
                    continue;
                }
                break;
            }
            catch (Exception e) {
                throw new DataAccessResourceFailureException("Failed to renew mutex at " + this.path, (Throwable)e);
            }
        }
    }
}

