/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.StoredProcOutboundGateway;
import org.springframework.integration.jdbc.dsl.StoredProcExecutorSpec;
import org.springframework.util.Assert;

public class JdbcStoredProcOutboundGatewaySpec
extends MessageHandlerSpec<JdbcStoredProcOutboundGatewaySpec, StoredProcOutboundGateway>
implements ComponentsRegistration {
    private final StoredProcExecutor storedProcExecutor;
    private @Nullable StoredProcExecutorSpec storedProcExecutorSpec;

    protected JdbcStoredProcOutboundGatewaySpec(StoredProcExecutorSpec storedProcExecutorSpec) {
        this((StoredProcExecutor)storedProcExecutorSpec.getObject());
        this.storedProcExecutorSpec = storedProcExecutorSpec;
    }

    protected JdbcStoredProcOutboundGatewaySpec(StoredProcExecutor storedProcExecutor) {
        this.storedProcExecutor = storedProcExecutor;
        this.storedProcExecutorSpec = null;
        this.target = new StoredProcOutboundGateway(this.storedProcExecutor);
    }

    public JdbcStoredProcOutboundGatewaySpec configurerStoredProcExecutor(Consumer<StoredProcExecutorSpec> configurer) {
        Assert.notNull(configurer, (String)"'configurer' must not be null");
        Assert.notNull((Object)((Object)this.storedProcExecutorSpec), (String)"The externally provided 'StoredProcExecutor' cannot be mutated in this spec");
        configurer.accept(this.storedProcExecutorSpec);
        return this;
    }

    public JdbcStoredProcOutboundGatewaySpec requiresReply(boolean requiresReply) {
        ((StoredProcOutboundGateway)((Object)this.target)).setRequiresReply(requiresReply);
        return this;
    }

    public JdbcStoredProcOutboundGatewaySpec expectSingleResult(boolean expectSingleResult) {
        ((StoredProcOutboundGateway)((Object)this.target)).setExpectSingleResult(expectSingleResult);
        return this;
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.storedProcExecutor, null);
    }
}

