/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.integration.support.converter.AllowListDeserializingConverter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MessageRowMapper
implements RowMapper<Message<?>> {
    private final AllowListDeserializingConverter deserializer;

    public MessageRowMapper(AllowListDeserializingConverter deserializer) {
        Assert.notNull((Object)deserializer, (String)"'deserializer' must not be null");
        this.deserializer = deserializer;
    }

    public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
        byte[] blobAsBytes = rs.getBytes("MESSAGE_BYTES");
        if (blobAsBytes == null) {
            return null;
        }
        return (Message)this.deserializer.convert(blobAsBytes);
    }
}

