/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.JdbcPollingChannelAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcPollingChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        String query;
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcPollingChannelAdapter.class);
        String dataSourceRef = element.getAttribute("data-source");
        String jdbcOperationsRef = element.getAttribute("jdbc-operations");
        boolean refToDataSourceSet = StringUtils.hasText((String)dataSourceRef);
        boolean refToJdbcOperationsSet = StringUtils.hasText((String)jdbcOperationsRef);
        if (refToDataSourceSet && refToJdbcOperationsSet || !refToDataSourceSet && !refToJdbcOperationsSet) {
            parserContext.getReaderContext().error("Exactly one of the attributes data-source or simple-jdbc-operations should be set for the JDBC inbound-channel-adapter", source);
        }
        if (!StringUtils.hasText((String)(query = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"query", (ParserContext)parserContext)))) {
            throw new BeanCreationException("The query attrbitue is required");
        }
        String update = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"update", (ParserContext)parserContext);
        if (refToDataSourceSet) {
            builder.addConstructorArgReference(dataSourceRef);
        } else {
            builder.addConstructorArgReference(jdbcOperationsRef);
        }
        builder.addConstructorArgValue((Object)query);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"row-mapper");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"update-sql-parameter-source-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"select-sql-parameter-source");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-rows-per-poll");
        if (update != null) {
            builder.addPropertyValue("updateSql", (Object)update);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"update-per-row");
        return builder.getBeanDefinition();
    }
}

