/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class TcpNetConnection
extends TcpConnectionSupport
implements SchedulingAwareRunnable {
    private final Lock lock = new ReentrantLock();
    private final Socket socket;
    private volatile @Nullable OutputStream socketOutputStream;
    private volatile long lastRead = System.currentTimeMillis();
    private volatile long lastSend;

    public TcpNetConnection(Socket socket, boolean server, boolean lookupHost, @Nullable ApplicationEventPublisher applicationEventPublisher, @Nullable String connectionFactoryName) {
        super(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName);
        this.socket = socket;
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public void close() {
        this.setNoReadErrorOnClose(true);
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void send(Message<?> message) {
        this.lock.lock();
        try {
            Object object;
            OutputStream socketOutputStreamToUse = this.socketOutputStream;
            if (socketOutputStreamToUse == null) {
                int writeBufferSize = this.socket.getSendBufferSize();
                this.socketOutputStream = socketOutputStreamToUse = new BufferedOutputStream(this.socket.getOutputStream(), writeBufferSize > 0 ? writeBufferSize : 8192);
            }
            Assert.state(((object = this.getMapper().fromMessage(message)) != null ? 1 : 0) != 0, () -> "The mapper returned null for message: " + String.valueOf(message));
            this.lastSend = System.currentTimeMillis();
            this.getSerializer().serialize(object, socketOutputStreamToUse);
            socketOutputStreamToUse.flush();
        }
        catch (Exception e) {
            MessagingException mex = new MessagingException(message, "Send Failed", (Throwable)e);
            this.publishConnectionExceptionEvent((Throwable)mex);
            this.closeConnection(true);
            throw mex;
        }
        finally {
            this.lock.unlock();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getConnectionId() + " Message sent " + String.valueOf(message)));
        }
    }

    @Override
    public Object getPayload() {
        InputStream inputStream;
        try {
            inputStream = this.inputStream();
        }
        catch (IOException e1) {
            throw new SoftEndOfStreamException("Socket closed when getting input stream", e1);
        }
        try {
            return this.getDeserializer().deserialize(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public @Nullable Object getDeserializerStateKey() {
        try {
            return this.inputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public @Nullable SSLSession getSslSession() {
        Socket socket = this.socket;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            return sslSocket.getSession();
        }
        return null;
    }

    protected InputStream inputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getConnectionId() + " Reading..."));
        }
        this.publishConnectionOpenEvent();
        while (this.receiveAndProcessMessage()) {
        }
    }

    private boolean receiveAndProcessMessage() {
        Message message;
        block9: {
            message = null;
            try {
                message = this.getMapper().toMessage(this);
                this.lastRead = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.publishConnectionExceptionEvent(e);
                if (!this.handleReadException(e)) break block9;
                return false;
            }
        }
        if (message != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received " + String.valueOf(message)));
            }
            try {
                TcpListener listener = this.getListener();
                if (listener == null) {
                    throw new NoListenerException("No listener");
                }
                listener.onMessage(message);
            }
            catch (NoListenerException nle) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Unexpected message - no endpoint registered with connection interceptor: " + this.getConnectionId() + " - " + String.valueOf(message)));
                }
            }
            catch (Exception e2) {
                this.logger.error((Object)("Exception sending message: " + String.valueOf(message)), (Throwable)e2);
            }
        }
        return true;
    }

    protected boolean handleReadException(Exception exception) {
        Exception e;
        Exception exception2 = e = exception instanceof UncheckedIOException ? (Exception)exception.getCause() : exception;
        if (e == null) {
            e = exception;
        }
        if (this.checkTimeout(e)) {
            boolean readErrorOnClose = !this.isNoReadErrorOnClose();
            this.closeConnection(true);
            if (!(e instanceof SoftEndOfStreamException)) {
                if (e instanceof SocketTimeoutException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Closed socket after timeout: " + this.getConnectionId()));
                    }
                } else {
                    this.logOtherExceptions(e, readErrorOnClose);
                }
                this.sendExceptionToListener(e);
            }
            return true;
        }
        return false;
    }

    private boolean checkTimeout(Exception e) {
        boolean doClose = true;
        if (!this.isServer() && e instanceof SocketTimeoutException) {
            long now = System.currentTimeMillis();
            try {
                int soTimeout = this.socket.getSoTimeout();
                if (now - this.lastSend < (long)soTimeout && now - this.lastRead < (long)soTimeout * 2L) {
                    doClose = false;
                }
                if (!doClose && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Skipping a socket timeout because we have a recent send " + this.getConnectionId()));
                }
            }
            catch (SocketException e1) {
                this.logger.error((Object)"Error accessing soTimeout", (Throwable)e1);
            }
        }
        return doClose;
    }

    private void logOtherExceptions(Exception e, boolean readErrorOnClose) {
        if (this.logger.isErrorEnabled()) {
            String messagePrefix = "Read exception " + this.getConnectionId();
            Supplier<String> summaryMessageSupplier = () -> messagePrefix + " " + e.getClass().getSimpleName() + ":" + (String)(e.getCause() != null ? String.valueOf(e.getCause()) + ":" : "") + e.getMessage();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)messagePrefix, (Throwable)e);
            } else if (readErrorOnClose) {
                this.logger.error((Object)summaryMessageSupplier.get());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)summaryMessageSupplier.get());
            }
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }
}

