/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.util.SimplePool;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class CachingClientConnectionFactory
extends AbstractClientConnectionFactory
implements DisposableBean {
    private final Lock lock = new ReentrantLock();
    private final AbstractClientConnectionFactory targetConnectionFactory;
    private final SimplePool<TcpConnectionSupport> pool;

    public CachingClientConnectionFactory(AbstractClientConnectionFactory target, int poolSize) {
        super("", 0);
        target.setSingleUse(true);
        this.targetConnectionFactory = target;
        this.pool = new SimplePool(poolSize, (SimplePool.PoolItemCallback)new TcpConnectionPoolItemCallback(this.targetConnectionFactory));
    }

    public void setConnectionWaitTimeout(int connectionWaitTimeout) {
        this.pool.setWaitTimeout((long)connectionWaitTimeout);
    }

    public void setPoolSize(int poolSize) {
        this.pool.setPoolSize(poolSize);
    }

    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    public int getIdleCount() {
        return this.pool.getIdleCount();
    }

    public int getActiveCount() {
        return this.pool.getActiveCount();
    }

    public int getAllocatedCount() {
        return this.pool.getAllocatedCount();
    }

    @Override
    public TcpConnectionSupport obtainConnection() {
        return new CachedConnection((TcpConnectionSupport)this.pool.getItem(), this.getListener());
    }

    @Override
    public boolean isRunning() {
        return this.targetConnectionFactory.isRunning();
    }

    public int hashCode() {
        return this.targetConnectionFactory.hashCode();
    }

    public void setComponentName(String componentName) {
        this.targetConnectionFactory.setComponentName(componentName);
    }

    @Override
    public String getComponentType() {
        return this.targetConnectionFactory.getComponentType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingClientConnectionFactory that = (CachingClientConnectionFactory)o;
        return this.targetConnectionFactory.equals(that.targetConnectionFactory);
    }

    @Override
    public int getSoTimeout() {
        return this.targetConnectionFactory.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.targetConnectionFactory.setSoTimeout(soTimeout);
    }

    @Override
    public int getSoReceiveBufferSize() {
        return this.targetConnectionFactory.getSoReceiveBufferSize();
    }

    @Override
    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.targetConnectionFactory.setSoReceiveBufferSize(soReceiveBufferSize);
    }

    @Override
    public int getSoSendBufferSize() {
        return this.targetConnectionFactory.getSoSendBufferSize();
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.targetConnectionFactory.setSoSendBufferSize(soSendBufferSize);
    }

    @Override
    public boolean isSoTcpNoDelay() {
        return this.targetConnectionFactory.isSoTcpNoDelay();
    }

    @Override
    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.targetConnectionFactory.setSoTcpNoDelay(soTcpNoDelay);
    }

    @Override
    public int getSoLinger() {
        return this.targetConnectionFactory.getSoLinger();
    }

    @Override
    public void setSoLinger(int soLinger) {
        this.targetConnectionFactory.setSoLinger(soLinger);
    }

    @Override
    public boolean isSoKeepAlive() {
        return this.targetConnectionFactory.isSoKeepAlive();
    }

    @Override
    public void setSoKeepAlive(boolean soKeepAlive) {
        this.targetConnectionFactory.setSoKeepAlive(soKeepAlive);
    }

    @Override
    public int getSoTrafficClass() {
        return this.targetConnectionFactory.getSoTrafficClass();
    }

    @Override
    public void setSoTrafficClass(int soTrafficClass) {
        this.targetConnectionFactory.setSoTrafficClass(soTrafficClass);
    }

    @Override
    public @Nullable String getHost() {
        return this.targetConnectionFactory.getHost();
    }

    @Override
    public int getPort() {
        return this.targetConnectionFactory.getPort();
    }

    @Override
    public @Nullable TcpSender getSender() {
        return this.targetConnectionFactory.getSender();
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.targetConnectionFactory.getSerializer();
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.targetConnectionFactory.getDeserializer();
    }

    @Override
    public TcpMessageMapper getMapper() {
        return this.targetConnectionFactory.getMapper();
    }

    @Override
    public void registerListener(TcpListener listener) {
        super.registerListener(listener);
        this.targetConnectionFactory.enableManualListenerRegistration();
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.targetConnectionFactory.registerSender(sender);
    }

    @Override
    public void setTaskExecutor(Executor taskExecutor) {
        this.targetConnectionFactory.setTaskExecutor(taskExecutor);
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.targetConnectionFactory.setDeserializer(deserializer);
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.targetConnectionFactory.setSerializer(serializer);
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.targetConnectionFactory.setMapper(mapper);
    }

    @Override
    public boolean isSingleUse() {
        return true;
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        if (!singleUse) {
            this.logger.debug((CharSequence)"singleUse=false is not supported; cached connections are never closed");
        }
    }

    @Override
    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.targetConnectionFactory.setInterceptorFactoryChain(interceptorFactoryChain);
    }

    @Override
    public void setLookupHost(boolean lookupHost) {
        this.targetConnectionFactory.setLookupHost(lookupHost);
    }

    @Override
    public boolean isLookupHost() {
        return this.targetConnectionFactory.isLookupHost();
    }

    @Override
    public void forceClose(TcpConnection connection) {
        if (connection instanceof CachedConnection) {
            CachedConnection cachedConnection = (CachedConnection)connection;
            cachedConnection.physicallyClose();
        }
        super.forceClose(connection);
    }

    @Override
    public void enableManualListenerRegistration() {
        super.enableManualListenerRegistration();
        this.targetConnectionFactory.enableManualListenerRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnection(String connectionId) {
        Assert.notNull((Object)connectionId, (String)"'connectionId' to close must not be null");
        String targetConnectionId = connectionId.replaceFirst("Cached:", "");
        this.connectionsMonitor.lock();
        try {
            TcpConnectionSupport targetConnection = (TcpConnectionSupport)this.targetConnectionFactory.connections.get(targetConnectionId);
            if (targetConnection != null) {
                if (!this.isRunning()) {
                    this.logger.debug(() -> "Factory not running - closing " + connectionId);
                    super.closeConnection(targetConnectionId);
                }
                this.pool.releaseItem((Object)targetConnection);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionsMonitor.unlock();
        }
    }

    @Override
    public void start() {
        this.setActive(true);
        this.targetConnectionFactory.start();
        super.start();
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.targetConnectionFactory.stop();
            this.pool.removeAllIdleItems();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        this.pool.close();
    }

    private record TcpConnectionPoolItemCallback(AbstractClientConnectionFactory targetConnectionFactory) implements SimplePool.PoolItemCallback<TcpConnectionSupport>
    {
        public TcpConnectionSupport createForPool() {
            try {
                return this.targetConnectionFactory.getConnection();
            }
            catch (Exception ex) {
                throw new MessagingException("Failed to obtain connection", (Throwable)ex);
            }
        }

        public boolean isStale(TcpConnectionSupport connection) {
            return !connection.isOpen();
        }

        public void removedFromPool(TcpConnectionSupport connection) {
            connection.close();
        }
    }

    private final class CachedConnection
    extends TcpConnectionInterceptorSupport {
        private final AtomicBoolean released = new AtomicBoolean();

        CachedConnection(@Nullable TcpConnectionSupport connection, TcpListener tcpListener) {
            super.setTheConnection(connection);
            super.registerListener(tcpListener);
        }

        @Override
        public void close() {
            if (!this.released.compareAndSet(false, true)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connection " + this.getConnectionId() + " has already been released"));
                }
            } else {
                if (!CachingClientConnectionFactory.this.isRunning()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Factory not running - closing " + this.getConnectionId()));
                    }
                    super.close();
                }
                CachingClientConnectionFactory.this.pool.releaseItem((Object)this.getTheConnection());
            }
        }

        @Override
        public String getConnectionId() {
            return "Cached:" + super.getConnectionId();
        }

        @Override
        public String toString() {
            return this.getConnectionId();
        }

        @Override
        public void onMessage(Message<?> message) {
            Message modifiedMessage;
            Object connectionId = message.getHeaders().get((Object)"ip_connectionId");
            if (message instanceof ErrorMessage) {
                HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)message.getHeaders());
                headers.put("ip_connectionId", this.getConnectionId());
                if (connectionId != null) {
                    headers.putIfAbsent("ip_actualConnectionId", connectionId);
                }
                modifiedMessage = new ErrorMessage((Throwable)message.getPayload(), headers);
            } else {
                AbstractIntegrationMessageBuilder messageBuilder = CachingClientConnectionFactory.this.getMessageBuilderFactory().fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId());
                if (message.getHeaders().get((Object)"ip_actualConnectionId") == null) {
                    messageBuilder.setHeader("ip_actualConnectionId", connectionId);
                }
                modifiedMessage = messageBuilder.build();
            }
            TcpListener listener = this.getListener();
            if (listener != null) {
                listener.onMessage(modifiedMessage);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message discarded; no listener: " + String.valueOf(message)));
            }
        }

        private void physicallyClose() {
            this.getTheConnection().close();
        }
    }
}

