/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.inbound;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionFailedCorrelationEvent;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class TcpInboundGateway
extends MessagingGatewaySupport
implements TcpListener,
TcpSender,
ClientModeCapable,
OrderlyShutdownCapable {
    public static final long DEFAULT_RETRY_INTERVAL = 60000L;
    private final Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();
    private final AtomicInteger activeCount = new AtomicInteger();
    private @Nullable AbstractServerConnectionFactory serverConnectionFactory;
    private @Nullable AbstractClientConnectionFactory clientConnectionFactory;
    private boolean isClientMode;
    private boolean isSingleUse;
    private long retryInterval = 60000L;
    private volatile @Nullable ClientModeConnectionManager clientModeConnectionManager;
    private volatile @Nullable ScheduledFuture<?> scheduledFuture;
    private volatile boolean shuttingDown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message<?> message) {
        block13: {
            boolean isErrorMessage = message instanceof ErrorMessage;
            try {
                if (this.shuttingDown) {
                    this.logger.info(() -> "Inbound message ignored; shutting down; " + String.valueOf(message));
                    break block13;
                }
                if (isErrorMessage) {
                    return;
                }
                this.activeCount.incrementAndGet();
                try {
                    this.doOnMessage(message);
                }
                finally {
                    this.activeCount.decrementAndGet();
                }
            }
            finally {
                String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
                if (connectionId != null && !isErrorMessage && this.isSingleUse) {
                    if (this.serverConnectionFactory != null) {
                        this.serverConnectionFactory.closeConnection(connectionId);
                    } else if (this.clientConnectionFactory != null) {
                        this.clientConnectionFactory.closeConnection(connectionId);
                    }
                }
            }
        }
    }

    private void doOnMessage(Message<?> message) {
        Message reply = this.sendAndReceiveMessage(message);
        if (reply == null) {
            this.logger.debug(() -> "null reply received for " + String.valueOf(message) + " nothing to send");
            return;
        }
        String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
        if (connectionId != null) {
            TcpConnection connection = this.connections.get(connectionId);
            if (connection == null) {
                this.publishNoConnectionEvent(message, connectionId);
                this.logger.error(() -> "Connection not found when processing reply " + String.valueOf(reply) + " for " + String.valueOf(message));
                return;
            }
            try {
                connection.send(reply);
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Failed to send reply");
            }
        }
    }

    private void publishNoConnectionEvent(Message<?> message, String connectionId) {
        AbstractConnectionFactory cf = this.serverConnectionFactory != null ? this.serverConnectionFactory : this.clientConnectionFactory;
        cf.getApplicationEventPublisher().publishEvent((ApplicationEvent)new TcpConnectionFailedCorrelationEvent(this, connectionId, new MessagingException(message, "Connection not found to process reply.")));
    }

    public boolean isListening() {
        return this.serverConnectionFactory != null && this.serverConnectionFactory.isListening();
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"Connection factory must not be null");
        if (connectionFactory instanceof AbstractServerConnectionFactory) {
            this.serverConnectionFactory = (AbstractServerConnectionFactory)connectionFactory;
        } else if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = (AbstractClientConnectionFactory)connectionFactory;
        } else {
            throw new IllegalArgumentException("Connection factory must be either an AbstractServerConnectionFactory or an AbstractClientConnectionFactory");
        }
        connectionFactory.registerListener(this);
        connectionFactory.registerSender(this);
        this.isSingleUse = connectionFactory.isSingleUse();
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-inbound-gateway";
    }

    protected void onInit() {
        super.onInit();
        Assert.state((this.serverConnectionFactory != null || this.clientConnectionFactory != null ? 1 : 0) != 0, (String)"An 'AbstractConnectionFactory' must not be provided.");
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    protected void doStart() {
        super.doStart();
        this.shuttingDown = false;
        if (this.serverConnectionFactory != null) {
            this.serverConnectionFactory.start();
        }
        if (this.clientConnectionFactory != null) {
            this.clientConnectionFactory.start();
        }
        if (this.isClientMode && this.clientConnectionFactory != null) {
            ClientModeConnectionManager manager;
            this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
            this.scheduledFuture = this.getTaskScheduler().scheduleAtFixedRate((Runnable)manager, Duration.ofMillis(this.retryInterval));
        }
    }

    protected void doStop() {
        super.doStop();
        ScheduledFuture<?> scheduledFutureToCancel = this.scheduledFuture;
        if (scheduledFutureToCancel != null) {
            scheduledFutureToCancel.cancel(true);
        }
        this.clientModeConnectionManager = null;
        if (this.clientConnectionFactory != null) {
            this.clientConnectionFactory.stop();
        }
        if (this.serverConnectionFactory != null) {
            this.serverConnectionFactory.stop();
        }
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        ClientModeConnectionManager clientModeConnectionManagerToCheck = this.clientModeConnectionManager;
        if (this.isClientMode && clientModeConnectionManagerToCheck != null) {
            return clientModeConnectionManagerToCheck.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        ClientModeConnectionManager clientModeConnectionManagerToRun = this.clientModeConnectionManager;
        if (this.isActive() && this.isClientMode && clientModeConnectionManagerToRun != null) {
            clientModeConnectionManagerToRun.run();
        }
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        this.stop();
        return this.activeCount.get();
    }
}

