/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.ip.util.RegexUtils;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.MessageMappingException;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DatagramPacketMessageMapper
implements InboundMessageMapper<DatagramPacket>,
OutboundMessageMapper<DatagramPacket>,
BeanFactoryAware {
    private static final Pattern UDP_HEADERS_PATTERN = Pattern.compile(RegexUtils.escapeRegexSpecials("ip_ackTo") + "=([^;]*);" + RegexUtils.escapeRegexSpecials("id") + "=([^;]*);");
    private String charset = StandardCharsets.UTF_8.name();
    private boolean acknowledge;
    private @Nullable String ackAddress;
    private boolean lengthCheck;
    private boolean lookupHost;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;
    private BeanFactory beanFactory;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setAcknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
    }

    public void setAckAddress(String ackAddress) {
        this.ackAddress = ackAddress;
    }

    public void setLengthCheck(boolean lengthCheck) {
        this.lengthCheck = lengthCheck;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public DatagramPacket fromMessage(Message<?> message) {
        if (this.acknowledge) {
            return this.fromMessageWithAck(message);
        }
        byte[] bytes = this.getPayloadAsBytes(message);
        if (this.lengthCheck) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 4);
            buffer.putInt(bytes.length);
            buffer.put(bytes);
            bytes = buffer.array();
        }
        return new DatagramPacket(bytes, bytes.length);
    }

    private DatagramPacket fromMessageWithAck(Message<?> message) {
        Assert.state((boolean)StringUtils.hasText((String)this.ackAddress), (String)"'ackAddress' must not be empty");
        byte[] bytes = this.getPayloadAsBytes(message);
        ByteBuffer buffer = ByteBuffer.allocate(100 + bytes.length);
        if (this.lengthCheck) {
            buffer.putInt(0);
        }
        try {
            buffer.put("ip_ackTo".getBytes(this.charset));
            buffer.put((byte)61);
            buffer.put(this.ackAddress.getBytes(this.charset));
            buffer.put((byte)59);
            UUID id = message.getHeaders().getId();
            if (id != null) {
                buffer.put("id".getBytes(this.charset));
                buffer.put((byte)61);
                buffer.put(id.toString().getBytes(this.charset));
                buffer.put((byte)59);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException(message, "Failed to get headers", (Throwable)e);
        }
        int headersLength = buffer.position() - 4;
        buffer.put(bytes);
        if (this.lengthCheck) {
            buffer.putInt(0, bytes.length + headersLength);
        }
        return new DatagramPacket(buffer.array(), buffer.position());
    }

    private byte[] getPayloadAsBytes(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            return (byte[])payload;
        }
        if (payload instanceof String) {
            try {
                return ((String)payload).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedIOException(e);
            }
        }
        throw new IllegalArgumentException("The datagram packet mapper expects either a byte array or String payload, but received: " + String.valueOf(payload.getClass()));
    }

    public @Nullable Message<byte[]> toMessage(DatagramPacket object) {
        return this.toMessage(object, null);
    }

    public @Nullable Message<byte[]> toMessage(DatagramPacket packet, @Nullable Map<String, Object> headers) {
        byte[] payload;
        String hostAddress;
        int offset = packet.getOffset();
        int length = packet.getLength();
        ByteBuffer buffer = ByteBuffer.wrap(packet.getData(), offset, length);
        Message message = null;
        if (this.lengthCheck) {
            int declaredLength = buffer.getInt();
            if (declaredLength != length - 4) {
                throw new MessageMappingException("Incorrect length; expected " + (declaredLength + 4) + ", received " + length);
            }
            offset += 4;
            length -= 4;
        }
        String hostName = hostAddress = packet.getAddress().getHostAddress();
        if (this.lookupHost) {
            hostName = packet.getAddress().getHostName();
        }
        int port = packet.getPort();
        if (this.acknowledge || this.startsWith(buffer, "ip_ackTo")) {
            try {
                String headersString = new String(packet.getData(), offset, length, this.charset);
                Matcher matcher = UDP_HEADERS_PATTERN.matcher(headersString);
                if (matcher.find()) {
                    payload = new byte[length -= matcher.end()];
                    System.arraycopy(packet.getData(), offset + matcher.end(), payload, 0, length);
                    message = this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("ip_ackId", (Object)UUID.fromString(matcher.group(2))).setHeader("ip_ackTo", (Object)matcher.group(1)).setHeader("ip_hostname", (Object)hostName).setHeader("ip_address", (Object)hostAddress).setHeader("ip_port", (Object)port).setHeader("ip_packetAddress", (Object)packet.getSocketAddress()).copyHeadersIfAbsent(headers).build();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageMappingException("Invalid charset", (Throwable)e);
            }
        }
        if (message == null) {
            payload = new byte[length];
            System.arraycopy(packet.getData(), offset, payload, 0, length);
            if (payload.length > 0) {
                message = this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("ip_hostname", (Object)hostName).setHeader("ip_address", (Object)hostAddress).setHeader("ip_port", (Object)port).setHeader("ip_packetAddress", (Object)packet.getSocketAddress()).build();
            }
        }
        return message;
    }

    private boolean startsWith(ByteBuffer buffer, String prefix) {
        int pos = buffer.position();
        if (buffer.limit() - pos < prefix.length()) {
            return false;
        }
        try {
            byte[] comparing;
            for (byte b : comparing = prefix.getBytes(this.charset)) {
                if (buffer.get() == b) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageMappingException("Invalid charset", (Throwable)e);
        }
        finally {
            buffer.position(pos);
        }
    }
}

