/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.messaging.MessagingException;

public class MulticastReceivingChannelAdapter
extends UnicastReceivingChannelAdapter {
    private final String group;

    public MulticastReceivingChannelAdapter(String group, int port) {
        super(port);
        this.group = group;
    }

    public MulticastReceivingChannelAdapter(String group, int port, boolean lengthCheck) {
        super(port, lengthCheck);
        this.group = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramSocket getSocket() {
        this.lock.lock();
        try {
            if (this.getTheSocket() == null) {
                try {
                    int port = this.getPort();
                    MulticastSocket socket = port == 0 ? new MulticastSocket() : new MulticastSocket(port);
                    String localAddress = this.getLocalAddress();
                    if (localAddress != null) {
                        socket.setNetworkInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(localAddress)));
                    }
                    this.setSocketAttributes(socket);
                    socket.joinGroup(new InetSocketAddress(this.group, 0), null);
                    this.setSocket(socket);
                }
                catch (IOException e) {
                    throw new MessagingException("failed to create DatagramSocket", (Throwable)e);
                }
            }
            DatagramSocket datagramSocket = super.getSocket();
            return datagramSocket;
        }
        finally {
            this.lock.unlock();
        }
    }
}

