/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.ip.dsl.TcpClientConnectionFactorySpec;
import org.springframework.integration.ip.tcp.TcpOutboundGateway;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class TcpOutboundGatewaySpec
extends MessageHandlerSpec<TcpOutboundGatewaySpec, TcpOutboundGateway>
implements ComponentsRegistration {
    protected final AbstractClientConnectionFactory connectionFactory;

    public TcpOutboundGatewaySpec(AbstractClientConnectionFactory connectionFactoryBean) {
        this.target = new TcpOutboundGateway();
        this.connectionFactory = null;
        ((TcpOutboundGateway)this.target).setConnectionFactory(connectionFactoryBean);
    }

    public TcpOutboundGatewaySpec(TcpClientConnectionFactorySpec connectionFactorySpec) {
        this.target = new TcpOutboundGateway();
        this.connectionFactory = (AbstractClientConnectionFactory)connectionFactorySpec.get();
        ((TcpOutboundGateway)this.target).setConnectionFactory(this.connectionFactory);
    }

    public TcpOutboundGatewaySpec remoteTimeout(long remoteTimeout) {
        ((TcpOutboundGateway)this.target).setRemoteTimeout(remoteTimeout);
        return this;
    }

    public <P> TcpOutboundGatewaySpec remoteTimeout(Function<Message<P>, ?> remoteTimeoutFunction) {
        ((TcpOutboundGateway)this.target).setRemoteTimeoutExpression((Expression)new FunctionExpression(remoteTimeoutFunction));
        return this;
    }

    public TcpOutboundGatewaySpec closeStreamAfterSend(boolean closeStreamAfterSend) {
        ((TcpOutboundGateway)this.target).setCloseStreamAfterSend(closeStreamAfterSend);
        return this;
    }

    public TcpOutboundGatewaySpec async(boolean async) {
        ((TcpOutboundGateway)this.target).setAsync(async);
        return this;
    }

    public TcpOutboundGatewaySpec unsolictedMessageChannelName(String channelName) {
        ((TcpOutboundGateway)this.target).setUnsolicitedMessageChannelName(channelName);
        return this;
    }

    public TcpOutboundGatewaySpec unsolictedMessageChannelName(MessageChannel channel) {
        ((TcpOutboundGateway)this.target).setUnsolicitedMessageChannel(channel);
        return this;
    }

    public Map<Object, String> getComponentsToRegister() {
        return this.connectionFactory != null ? Collections.singletonMap(this.connectionFactory, this.connectionFactory.getComponentName()) : null;
    }
}

