/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractHttpRequestExecutingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static final List<HttpMethod> noBodyHttpMethods = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE);
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final Expression uriExpression;
    private StandardEvaluationContext evaluationContext;
    private SimpleEvaluationContext simpleEvaluationContext;
    private boolean trustedSpel;
    private volatile boolean encodeUri = true;
    private volatile Expression httpMethodExpression = new ValueExpression((Object)HttpMethod.POST);
    private volatile boolean expectReply = true;
    private volatile Expression expectedResponseTypeExpression;
    private volatile boolean extractPayload = true;
    private volatile boolean extractPayloadExplicitlySet = false;
    private volatile Charset charset = Charset.forName("UTF-8");
    private volatile boolean transferCookies = false;
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private volatile Expression uriVariablesExpression;

    public AbstractHttpRequestExecutingMessageHandler(Expression uriExpression) {
        Assert.notNull((Object)uriExpression, (String)"URI Expression is required");
        this.uriExpression = uriExpression;
    }

    public void setEncodeUri(boolean encodeUri) {
        this.encodeUri = encodeUri;
    }

    public void setHttpMethodExpression(Expression httpMethodExpression) {
        Assert.notNull((Object)httpMethodExpression, (String)"'httpMethodExpression' must not be null");
        this.httpMethodExpression = httpMethodExpression;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
        this.httpMethodExpression = new ValueExpression((Object)httpMethod);
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
        this.extractPayloadExplicitlySet = true;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = Charset.forName(charset);
    }

    public boolean isExpectReply() {
        return this.expectReply;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        Assert.notNull(expectedResponseType, (String)"'expectedResponseType' must not be null");
        this.expectedResponseTypeExpression = new ValueExpression(expectedResponseType);
    }

    public void setExpectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        this.expectedResponseTypeExpression = expectedResponseTypeExpression;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setUriVariablesExpression(Expression uriVariablesExpression) {
        this.uriVariablesExpression = uriVariablesExpression;
    }

    public void setTransferCookies(boolean transferCookies) {
        this.transferCookies = transferCookies;
    }

    public void setTrustedSpel(boolean trustedSpel) {
        this.trustedSpel = trustedSpel;
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        this.simpleEvaluationContext = ExpressionUtils.createSimpleEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        HttpMethod httpMethod = this.determineHttpMethod(requestMessage);
        if (!this.shouldIncludeRequestBody(httpMethod) && this.extractPayloadExplicitlySet && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'extractPayload' attribute has no relevance for the current request since the HTTP Method is '" + httpMethod + "', and no request body will be sent for that method."));
        }
        Object expectedResponseType = this.determineExpectedResponseType(requestMessage);
        HttpEntity<?> httpRequest = this.generateHttpRequest(requestMessage, httpMethod);
        return this.exchange(() -> this.generateUri(requestMessage), httpMethod, httpRequest, expectedResponseType, requestMessage);
    }

    protected abstract Object exchange(Supplier<URI> var1, HttpMethod var2, HttpEntity<?> var3, Object var4, Message<?> var5);

    private URI generateUri(Message<?> requestMessage) {
        Object uri = this.uriExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        Assert.state((uri instanceof String || uri instanceof URI ? 1 : 0) != 0, (String)("'uriExpression' evaluation must result in a 'String' or 'URI' instance, not: " + (uri == null ? "null" : uri.getClass())));
        Map<String, ?> uriVariables = this.determineUriVariables(requestMessage);
        UriComponentsBuilder uriComponentsBuilder = uri instanceof String ? UriComponentsBuilder.fromUriString((String)((String)uri)) : UriComponentsBuilder.fromUri((URI)((URI)uri));
        UriComponents uriComponents = uriComponentsBuilder.buildAndExpand(uriVariables);
        try {
            return this.encodeUri ? uriComponents.toUri() : new URI(uriComponents.toUriString());
        }
        catch (URISyntaxException e) {
            throw new MessageHandlingException(requestMessage, "Invalid URI [" + uri + "]", (Throwable)e);
        }
    }

    protected Object getReply(ResponseEntity<?> httpResponse) {
        if (this.expectReply) {
            Object responseBody;
            HttpHeaders httpHeaders = httpResponse.getHeaders();
            Map headers = this.headerMapper.toHeaders((Object)httpHeaders);
            if (this.transferCookies) {
                this.doConvertSetCookie(headers);
            }
            AbstractIntegrationMessageBuilder replyBuilder = null;
            MessageBuilderFactory messageBuilderFactory = this.getMessageBuilderFactory();
            replyBuilder = httpResponse.hasBody() ? ((responseBody = httpResponse.getBody()) instanceof Message ? messageBuilderFactory.fromMessage((Message)responseBody) : messageBuilderFactory.withPayload(responseBody)) : messageBuilderFactory.withPayload(httpResponse);
            replyBuilder.setHeader("http_statusCode", (Object)httpResponse.getStatusCode());
            return replyBuilder.copyHeaders(headers);
        }
        return null;
    }

    private void doConvertSetCookie(Map<String, Object> headers) {
        String keyName = null;
        for (String key : headers.keySet()) {
            if (!key.equalsIgnoreCase("Set-Cookie")) continue;
            keyName = key;
            break;
        }
        if (keyName != null) {
            Object cookies = headers.remove(keyName);
            headers.put("Cookie", cookies);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Converted Set-Cookie header to Cookie for: " + cookies));
            }
        }
    }

    private HttpEntity<?> generateHttpRequest(Message<?> message, HttpMethod httpMethod) {
        Assert.notNull(message, (String)"message must not be null");
        return this.extractPayload ? this.createHttpEntityFromPayload(message, httpMethod) : this.createHttpEntityFromMessage(message, httpMethod);
    }

    private HttpEntity<?> createHttpEntityFromPayload(Message<?> message, HttpMethod httpMethod) {
        MultiValueMap<Object, Object> payload = message.getPayload();
        if (payload instanceof HttpEntity) {
            return (HttpEntity)payload;
        }
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (!this.shouldIncludeRequestBody(httpMethod)) {
            return new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (httpHeaders.getContentType() == null) {
            MediaType contentType = payload instanceof String ? this.resolveContentType((String)payload, this.charset) : this.resolveContentType(payload);
            httpHeaders.setContentType(contentType);
        }
        if ((MediaType.APPLICATION_FORM_URLENCODED.equals((Object)httpHeaders.getContentType()) || MediaType.MULTIPART_FORM_DATA.equals((Object)httpHeaders.getContentType())) && !(payload instanceof MultiValueMap)) {
            payload = this.convertToMultiValueMap((Map)payload);
        }
        return new HttpEntity(payload, (MultiValueMap)httpHeaders);
    }

    private HttpEntity<?> createHttpEntityFromMessage(Message<?> message, HttpMethod httpMethod) {
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (this.shouldIncludeRequestBody(httpMethod)) {
            httpHeaders.setContentType(new MediaType("application", "x-java-serialized-object"));
            return new HttpEntity(message, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    protected HttpHeaders mapHeaders(Message<?> message) {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)httpHeaders);
        return httpHeaders;
    }

    private MediaType resolveContentType(Object content) {
        MediaType contentType = null;
        if (content instanceof byte[]) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        } else if (content instanceof Source) {
            contentType = MediaType.TEXT_XML;
        } else if (content instanceof Map && this.isFormData((Map)content)) {
            contentType = this.isMultipart((Map)content) ? MediaType.MULTIPART_FORM_DATA : MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (contentType == null) {
            contentType = new MediaType("application", "x-java-serialized-object");
        }
        return contentType;
    }

    private boolean shouldIncludeRequestBody(HttpMethod httpMethod) {
        return !CollectionUtils.containsInstance(noBodyHttpMethods, (Object)httpMethod);
    }

    private MediaType resolveContentType(String content, Charset charset) {
        return new MediaType("text", "plain", charset);
    }

    private MultiValueMap<Object, Object> convertToMultiValueMap(Map<?, ?> simpleMap) {
        LinkedMultiValueMap multipartValueMap = new LinkedMultiValueMap();
        for (Map.Entry<?, ?> entry : simpleMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                value = Arrays.asList((Object[])value);
            }
            if (value instanceof Collection) {
                multipartValueMap.put(key, new ArrayList((Collection)value));
                continue;
            }
            multipartValueMap.add(key, value);
        }
        return multipartValueMap;
    }

    private boolean isMultipart(Map<String, ?> map) {
        for (Object value : map.values()) {
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CollectionUtils.arrayToList(value);
            }
            if (value instanceof Collection) {
                Collection cValues = (Collection)value;
                for (Object cValue : cValues) {
                    if (cValue == null || cValue instanceof String) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof String) continue;
            return true;
        }
        return false;
    }

    private boolean isFormData(Map<Object, ?> map) {
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return false;
        }
        return true;
    }

    private HttpMethod determineHttpMethod(Message<?> requestMessage) {
        Object httpMethod = this.httpMethodExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        Assert.state((httpMethod != null && (httpMethod instanceof String || httpMethod instanceof HttpMethod) ? 1 : 0) != 0, (String)("'httpMethodExpression' evaluation must result in an 'HttpMethod' enum or its String representation, not: " + (httpMethod == null ? "null" : httpMethod.getClass())));
        if (httpMethod instanceof HttpMethod) {
            return (HttpMethod)httpMethod;
        }
        try {
            return HttpMethod.valueOf((String)((String)httpMethod));
        }
        catch (Exception e) {
            throw new IllegalStateException("The 'httpMethodExpression' returned an invalid HTTP Method value: " + httpMethod);
        }
    }

    private Object determineExpectedResponseType(Message<?> requestMessage) {
        Object expectedResponseType = null;
        if (this.expectedResponseTypeExpression != null) {
            expectedResponseType = this.expectedResponseTypeExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        }
        if (expectedResponseType != null) {
            Assert.state((expectedResponseType instanceof Class || expectedResponseType instanceof String || expectedResponseType instanceof ParameterizedTypeReference ? 1 : 0) != 0, (String)("'expectedResponseType' can be an instance of 'Class<?>', 'String' or 'ParameterizedTypeReference<?>'; evaluation resulted in a" + expectedResponseType.getClass() + "."));
            if (expectedResponseType instanceof String && StringUtils.hasText((String)((String)expectedResponseType))) {
                try {
                    expectedResponseType = ClassUtils.forName((String)((String)expectedResponseType), (ClassLoader)this.getApplicationContext().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load class for name: " + expectedResponseType, e);
                }
            }
        }
        return expectedResponseType;
    }

    private Map<String, ?> determineUriVariables(Message<?> requestMessage) {
        Map expressions;
        StandardEvaluationContext evaluationContextToUse = this.evaluationContext;
        if (this.uriVariablesExpression != null) {
            Object expressionsObject = this.uriVariablesExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
            Assert.state((boolean)(expressionsObject instanceof Map), (String)"The 'uriVariablesExpression' evaluation must result in a 'Map'.");
            expressions = (Map)expressionsObject;
            if (!this.trustedSpel) {
                evaluationContextToUse = this.simpleEvaluationContext;
            }
        } else {
            expressions = this.uriVariableExpressions;
        }
        return ExpressionEvalMap.from(expressions).usingEvaluationContext((EvaluationContext)evaluationContextToUse).withRoot(requestMessage).build();
    }
}

