/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.message;

import org.springframework.util.Assert;

public class EntryEventMessagePayload<K, V> {
    public final K key;
    public final V value;
    public final V oldValue;

    public EntryEventMessagePayload(K key, V value, V oldValue) {
        Assert.notNull(key, (String)"'key' must not be null");
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
    }

    public String toString() {
        return "EntryEventMessagePayload [key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", oldValue=" + String.valueOf(this.oldValue) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryEventMessagePayload that = (EntryEventMessagePayload)o;
        return this.key.equals(that.key) && !(this.value == null ? that.value != null : !this.value.equals(that.value)) && !(this.oldValue == null ? that.oldValue != null : !this.oldValue.equals(that.oldValue));
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        return result;
    }
}

