/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.groovy.config.GroovyAwareScriptExecutingProcessorFactory;

public class GroovyIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log LOGGER = LogFactory.getLog(GroovyIntegrationConfigurationInitializer.class);

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerScriptExecutorProviderIfNecessary((BeanDefinitionRegistry)beanFactory);
        } else {
            LOGGER.warn((Object)"The 'ScriptExecutingProcessorFactory' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    protected void registerScriptExecutorProviderIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("integrationScriptExecutingProcessorFactory")) {
            registry.registerBeanDefinition("integrationScriptExecutingProcessorFactory", (BeanDefinition)new RootBeanDefinition(GroovyAwareScriptExecutingProcessorFactory.class));
        }
    }
}

