/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.graphql.outbound;

import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.SupplierExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class GraphQlMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final ExecutionGraphQlService graphQlService;
    private StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    @Nullable
    private Expression operationExpression;
    private Expression operationNameExpression = new SupplierExpression(() -> null);
    private Expression variablesExpression = new SupplierExpression(() -> null);
    @Nullable
    private Locale locale;
    private Expression executionIdExpression = new FunctionExpression(message -> message.getHeaders().getId());

    public GraphQlMessageHandler(ExecutionGraphQlService graphQlService) {
        Assert.notNull((Object)graphQlService, (String)"'graphQlService' must not be null");
        this.graphQlService = graphQlService;
        this.setAsync(true);
    }

    public void setOperation(String operation) {
        Assert.hasText((String)operation, (String)"'operation' must not be empty");
        this.setOperationExpression((Expression)new LiteralExpression(operation));
    }

    public void setOperationExpression(Expression operationExpression) {
        Assert.notNull((Object)operationExpression, (String)"'queryExpression' must not be null");
        this.operationExpression = operationExpression;
    }

    public void setOperationName(String operationName) {
        this.setOperationNameExpression((Expression)new LiteralExpression(operationName));
    }

    public void setOperationNameExpression(Expression operationNameExpression) {
        Assert.notNull((Object)operationNameExpression, (String)"'operationNameExpression' must not be null");
        this.operationNameExpression = operationNameExpression;
    }

    public void setVariablesExpression(Expression variablesExpression) {
        Assert.notNull((Object)variablesExpression, (String)"'variablesExpression' must not be null");
        this.variablesExpression = variablesExpression;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale;
    }

    public void setExecutionIdExpression(Expression executionIdExpression) {
        Assert.notNull((Object)executionIdExpression, (String)"'executionIdExpression' must not be null");
        this.executionIdExpression = executionIdExpression;
    }

    protected final void doInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory);
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        ExecutionGraphQlRequest graphQlRequest;
        if (requestMessage.getPayload() instanceof ExecutionGraphQlRequest) {
            graphQlRequest = (ExecutionGraphQlRequest)requestMessage.getPayload();
        } else {
            String query = this.evaluateOperationExpression(requestMessage);
            String operationName = this.evaluateOperationNameExpression(requestMessage);
            Map<String, Object> variables = this.evaluateVariablesExpression(requestMessage);
            String id = this.evaluateExecutionIdExpression(requestMessage);
            Assert.notNull((Object)id, (String)"The 'executionIdExpression' must not evaluate to null");
            graphQlRequest = new DefaultExecutionGraphQlRequest(query, operationName, variables, null, id, this.locale);
        }
        return this.graphQlService.execute(graphQlRequest);
    }

    private String evaluateOperationExpression(Message<?> message) {
        Assert.notNull((Object)this.operationExpression, (String)"'operationExpression' must not be null");
        String operation = (String)this.operationExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
        Assert.notNull((Object)operation, (String)"'operationExpression' must not evaluate to null");
        return operation;
    }

    @Nullable
    private String evaluateOperationNameExpression(Message<?> message) {
        return (String)this.operationNameExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
    }

    @Nullable
    private Map<String, Object> evaluateVariablesExpression(Message<?> message) {
        return (Map)this.variablesExpression.getValue((EvaluationContext)this.evaluationContext, message, Map.class);
    }

    @Nullable
    private String evaluateExecutionIdExpression(Message<?> message) {
        return (String)this.executionIdExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
    }
}

